using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using SharpDX;
using SharpDX.D3DCompiler;
using SharpDX.Direct3D11;
using SharpDX.DXGI;
using SharpDX.Windows;
using Framefield.Core.Rendering;

namespace Framefield.Core.IDd1c777ae_8ba3_4d47_aebb_6346df9d607a
{
    public class Class_HighlightFX : OperatorPart.Function
    {
        public class Renderer : BaseRenderer
        {
            public override void SetupEffect(OperatorPartContext context) {
                base.SetupEffect(context);
                context.Effect.GetVariableByName("multiplyColor").AsVector().Set(_colorA);
                context.Effect.GetVariableByName("offsetColor").AsVector().Set(_colorB);
            }
            public SharpDX.Vector4 _colorA;
            public SharpDX.Vector4 _colorB;
        }

        public Class_HighlightFX() {
            using (var bytecode = ShaderBytecode.CompileFromFile("assets-common/fx/FlatHighlightShader.fx", "fx_5_0", ShaderFlags.None, EffectFlags.None, null, null))
                _effect = new Effect(D3DDevice.Device, bytecode);
            _renderer = new Renderer();
        }

        public override void Dispose() {
            Utilities.DisposeObj(ref _effect);
            Utilities.DisposeObj(ref _renderer);
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            var Scene = inputs[0];//.Eval(context);
            var ColorAR = inputs[1].Eval(context).Value;
            var ColorAG = inputs[2].Eval(context).Value;
            var ColorAB = inputs[3].Eval(context).Value;
            var ColorAA = inputs[4].Eval(context).Value;
            var ColorBR = inputs[5].Eval(context).Value;
            var ColorBG = inputs[6].Eval(context).Value;
            var ColorBB = inputs[7].Eval(context).Value;
            var ColorBA = inputs[8].Eval(context).Value;

            _renderer._colorA = new SharpDX.Vector4(ColorAR, ColorAG, ColorAB, ColorAA);
            _renderer._colorB = new SharpDX.Vector4(ColorBR, ColorBG, ColorBB, ColorBA);            

            var D3DDevice = context.D3DDevice;
            var subContext = new OperatorPartContext(context);
            try {
                subContext.Effect = _effect;
                subContext.InputLayout = context.Renderer.SceneDefaultInputLayout;
                subContext.Renderer = _renderer;

                Scene.Eval(subContext);
            }
            catch (Exception exception) {
                Logger.Error(this,"Load Effect error: {0}", exception.Message);
            }

            return context;
        }

        Effect _effect;
        Renderer _renderer;
    }
}

