using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;

using System.Globalization;

namespace Framefield.Core.ID0979ebaa_be12_4f65_92a2_7c5f7b130ebe
{

    public class Class_FormatedTimeSinceDate : OperatorPart.Function, Framefield.Core.OperatorPartTraits.ITimeAccessor
    {
        //>>> _inputids
        private enum InputId
        {
            Year = 0,
            Month = 1,
            Day = 2,
            Format = 3
        }
        //<<< _inputids
        
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Year = inputs[(int)InputId.Year].Eval(context).Value;
            var Month = inputs[(int)InputId.Month].Eval(context).Value;
            var Day = inputs[(int)InputId.Day].Eval(context).Value;
            var Format = inputs[(int)InputId.Format].Eval(context).Text;
            //<<< _params

            DateTime startDate = new DateTime((int)Math.Floor(Year),(int)Math.Round(Month),(int)Math.Round(Day));
            
            TimeSpan duration = DateTime.Now - startDate;
            context.Text = String.Format(Format, duration);
                        
            return context;
        }
    }
}


