using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.D3DCompiler;
using SharpDX.Direct3D11;
using SharpDX.DXGI;

namespace Framefield.Core.ID9b732a2b_0313_4ab2_9a39_463f6c78e812
{
    public class Class_DefaultNearest : OperatorPart.Function
    {
        public Class_DefaultNearest() {
            try {
                using (var bytecode = ShaderBytecode.CompileFromFile("assets-common/fx/DefaultNearest.fx", "fx_5_0", ShaderFlags.None, EffectFlags.None, null, null))
                    _effect = new Effect(D3DDevice.Device, bytecode);
            }
            catch (Exception e) {
                Logger.Error(this,"error loading laye2d fx: {0} ", e.Message);
            }
        }

        public override void  Dispose() {
            Utilities.DisposeObj(ref _effect);
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            var Scene = inputs[0];

            using (new PropertyStasher<OperatorPartContext>(context, "Effect")) {
                context.Effect = _effect;
                Scene.Eval(context);
            }

            return context;
        }

        Effect _effect = null;
    }
}

