//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID7772a238_d925_4013_a6e7_766cf553e922
{
    public class Class_VariableString : OperatorPart.Function, Framefield.Core.OperatorPartTraits.IVariableAccessor, Framefield.Core.OperatorPartTraits.ITimeAccessor
    {
        //>>> _inputids
        private enum InputId
        {
            Name = 0
        }
        //<<< _inputids

        public string VariableName
        {
            get
            {
                return OperatorPartUtilities.GetInputTextValue(OperatorPart.Connections[(int)InputId.Name]);
            }
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Name = inputs[(int)InputId.Name].Eval(context).Text;
            //<<< _params

            object v;
            if (context.Objects.TryGetValue(Name, out v))
                context.Text = v as string;
            else
                context.Text = String.Format("Variable \"{0}\" not found!", Name);

            return context;
        }
    }
}
