using System;
using System.Collections.Generic;
using System.Dynamic;
using System.Linq;
using System.Text;
using System.Xml;
using SharpDX;

namespace Framefield.Core.ID3733bbeb_c4fe_41a6_9ec5_404861a84c0a
{
    public class Class_StringsFromXmlFile : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            FilePath = 0
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var FilePath = inputs[(int)InputId.FilePath].Eval(context).Text;
            //<<< _params

            dynamic obj = new ExpandoObject();

            XmlDocument doc = new XmlDocument();
            doc.Load(FilePath);
            XmlElement root = doc.DocumentElement;

            var list = new List<string>();
            foreach (XmlNode item in root.GetElementsByTagName("item")) {
                var value = item["title"].InnerText;
                list.Add(value);
            }

            context.Dynamic = list;
            return context;
        }
    }
}

