//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using Framefield.Core.Profiling;

namespace Framefield.Core.ID04ce3e97_08f5_49b0_9dec_a7c813948cfe
{
    public class Class_StretchedTime : OperatorPart.Function, Framefield.Core.OperatorPartTraits.ITimeAccessor
    {
        //>>> _inputids
        private enum InputId
        {
            ResetTrigger = 0,
            Speed = 1,
            ClampRangeMin = 2,
            ClampRangeMax = 3
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var ResetTrigger = inputs[(int)InputId.ResetTrigger].Eval(context).Value;
            var Speed = inputs[(int)InputId.Speed].Eval(context).Value;
            var ClampRangeMin = inputs[(int)InputId.ClampRangeMin].Eval(context).Value;
            var ClampRangeMax = inputs[(int)InputId.ClampRangeMax].Eval(context).Value;
            var ClampRange = new Vector2(ClampRangeMin, ClampRangeMax);
            //<<< _params
            
            var resetPressed = (ResetTrigger - _lastResetTrigger  > 0.5f); 
            if(resetPressed) {
                _time = 0;
            }
                                    
            if(context.GlobalTime != _lastTime) {            
                var duration = (float)(context.GlobalTime - _lastTime);
                _lastTime = context.GlobalTime;
                _time += duration * Speed;                
            }
            _time = Utilities.Clamp( _time, ClampRangeMin, ClampRangeMax);
            context.Value = (float)_time;;
            return context;
        }

        private double _time; 
        private double _lastTime;
        private float _lastResetTrigger;
    }
}


