//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

using System.Collections;
using OSC;

namespace Framefield.Core.ID8a5fa784_ee95_4424_9274_d84f9d0c3b51
{
    public class Class_OSCMessageString : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            OSCPath = 0,
            FrameMessages = 1
        }
        //<<< _inputids
        
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            if (Changed)
            {
                //>>> _params
                var OSCPath = inputs[(int)InputId.OSCPath].Eval(context).Text;
                var FrameMessages = inputs[(int)InputId.FrameMessages].Eval(context).Dynamic;  // Needs to be checked for null!
                //<<< _params
                
                if (FrameMessages != null)
                {
                    var dict = (IDictionary<string, OSCMessage>)FrameMessages;
                    OSCMessage msg;
                    
                    if (dict.TryGetValue(OSCPath, out msg))
                    {
                        if (msg.Values.Count != 1)
                        {
                            Logger.Error(this, "Expected 1 param, got " + msg.Values.Count);
                            return context;
                        }
                        
                        // This will convert anything to string, i.e. if the message
                        // contains a float value 1.0, the result will be "1.0"
                        // I think it may be useful in some cases, although it's not that strict as it could be
                        // if the check of the message type was performed (s).
                        _lastValue = Convert.ToString(msg.Values[0]);
                    }
                }
            
                Changed = false;
            }

            context.Text = _lastValue;
            return context;
        }
		
		private string _path;
		private string _lastValue; 
    }
}

