//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID6fd1cc00_ad87_4136_87c2_32a07a4a47f9
{
    public class Class_LightGizmos : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            SceneInput = 0,
            Widget = 1
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var SceneInput = inputs[(int)InputId.SceneInput];
            var Widget = inputs[(int)InputId.Widget];
            //<<< _params
            SceneInput.Eval(context);

            var prevTransform = context.ObjectTWorld;
            
            var pointLightContainer = (HashSet<IPointLight>) context.Objects[OperatorPartContext.POINT_LIGHT_CONTAINER_ID];
            foreach (var pointLight in pointLightContainer) {
                context.ObjectTWorld = Matrix.Translation(pointLight.Position);
                Widget.Eval(context);
            }

            context.ObjectTWorld = prevTransform;
            
            return context;
        }
    }
}

