//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDb1bfc2e4_52bc_4e59_a772_bdec92bf206f
{
    public class Class_EnergiePhysik : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Color1R = 1,
            Color1G = 2,
            Color1B = 3,
            Color1A = 4,
            Color2R = 5,
            Color2G = 6,
            Color2B = 7,
            Color2A = 8,
            Minrad = 9,
            Farrad = 10,
            Scale = 11,
            StepCount = 12,
            StepSize = 13,
            LightPosX = 14,
            LightPosY = 15,
            LightPosZ = 16,
            SpecularSize = 17,
            SpecularPower = 18,
            FogDistance = 19,
            AmbientOcclusionSize = 20,
            AmbientOcclusionStrength = 21,
            AOColorR = 22,
            AOColorG = 23,
            AOColorB = 24,
            AOColorA = 25,
            FogDecay = 26,
            Image = 27,
            aoSteps = 28,
            MinDist = 29,
            Image2 = 30,
            ClampingMin = 31,
            ClampingMax = 32,
            ClampingFactor = 33,
            FoldX = 34,
            FoldY = 35,
            IncrementX = 36,
            IncrementY = 37,
            IncrementZ = 38,
            SphereX = 39,
            SphereY = 40,
            SphereZ = 41,
            SphereRadius = 42,
            BackgroundColorR = 43,
            BackgroundColorG = 44,
            BackgroundColorB = 45,
            BackgroundColorA = 46,
            DistToColor = 47,
            GlowColorR = 48,
            GlowColorG = 49,
            GlowColorB = 50,
            GlowColorA = 51,
            GlowStrength = 52
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Color1R = inputs[(int)InputId.Color1R].Eval(context).Value;
            var Color1G = inputs[(int)InputId.Color1G].Eval(context).Value;
            var Color1B = inputs[(int)InputId.Color1B].Eval(context).Value;
            var Color1A = inputs[(int)InputId.Color1A].Eval(context).Value;
            var Color1 = new Color4(Color1R, Color1G, Color1B, Color1A);
            var Color2R = inputs[(int)InputId.Color2R].Eval(context).Value;
            var Color2G = inputs[(int)InputId.Color2G].Eval(context).Value;
            var Color2B = inputs[(int)InputId.Color2B].Eval(context).Value;
            var Color2A = inputs[(int)InputId.Color2A].Eval(context).Value;
            var Color2 = new Color4(Color2R, Color2G, Color2B, Color2A);
            var Minrad = inputs[(int)InputId.Minrad].Eval(context).Value;
            var Farrad = inputs[(int)InputId.Farrad].Eval(context).Value;
            var Scale = inputs[(int)InputId.Scale].Eval(context).Value;
            var StepCount = inputs[(int)InputId.StepCount].Eval(context).Value;
            var StepSize = inputs[(int)InputId.StepSize].Eval(context).Value;
            var LightPosX = inputs[(int)InputId.LightPosX].Eval(context).Value;
            var LightPosY = inputs[(int)InputId.LightPosY].Eval(context).Value;
            var LightPosZ = inputs[(int)InputId.LightPosZ].Eval(context).Value;
            var LightPos = new Vector3(LightPosX, LightPosY, LightPosZ);
            var SpecularSize = inputs[(int)InputId.SpecularSize].Eval(context).Value;
            var SpecularPower = inputs[(int)InputId.SpecularPower].Eval(context).Value;
            var Specular = new Vector2(SpecularSize, SpecularPower);
            var FogDistance = inputs[(int)InputId.FogDistance].Eval(context).Value;
            var AmbientOcclusionSize = inputs[(int)InputId.AmbientOcclusionSize].Eval(context).Value;
            var AmbientOcclusionStrength = inputs[(int)InputId.AmbientOcclusionStrength].Eval(context).Value;
            var AmbientOcclusion = new Vector2(AmbientOcclusionSize, AmbientOcclusionStrength);
            var AOColorR = inputs[(int)InputId.AOColorR].Eval(context).Value;
            var AOColorG = inputs[(int)InputId.AOColorG].Eval(context).Value;
            var AOColorB = inputs[(int)InputId.AOColorB].Eval(context).Value;
            var AOColorA = inputs[(int)InputId.AOColorA].Eval(context).Value;
            var AOColor = new Color4(AOColorR, AOColorG, AOColorB, AOColorA);
            var FogDecay = inputs[(int)InputId.FogDecay].Eval(context).Value;
            var Image = inputs[(int)InputId.Image].Eval(context).Image; if (Image == null) return context;
            var aoSteps = inputs[(int)InputId.aoSteps].Eval(context).Value;
            var MinDist = inputs[(int)InputId.MinDist].Eval(context).Value;
            var Image2 = inputs[(int)InputId.Image2].Eval(context).Image; if (Image2 == null) return context;
            var ClampingMin = inputs[(int)InputId.ClampingMin].Eval(context).Value;
            var ClampingMax = inputs[(int)InputId.ClampingMax].Eval(context).Value;
            var ClampingFactor = inputs[(int)InputId.ClampingFactor].Eval(context).Value;
            var Clamping = new Vector3(ClampingMin, ClampingMax, ClampingFactor);
            var FoldX = inputs[(int)InputId.FoldX].Eval(context).Value;
            var FoldY = inputs[(int)InputId.FoldY].Eval(context).Value;
            var Fold = new Vector2(FoldX, FoldY);
            var IncrementX = inputs[(int)InputId.IncrementX].Eval(context).Value;
            var IncrementY = inputs[(int)InputId.IncrementY].Eval(context).Value;
            var IncrementZ = inputs[(int)InputId.IncrementZ].Eval(context).Value;
            var Increment = new Vector3(IncrementX, IncrementY, IncrementZ);
            var SphereX = inputs[(int)InputId.SphereX].Eval(context).Value;
            var SphereY = inputs[(int)InputId.SphereY].Eval(context).Value;
            var SphereZ = inputs[(int)InputId.SphereZ].Eval(context).Value;
            var Sphere = new Vector3(SphereX, SphereY, SphereZ);
            var SphereRadius = inputs[(int)InputId.SphereRadius].Eval(context).Value;
            var BackgroundColorR = inputs[(int)InputId.BackgroundColorR].Eval(context).Value;
            var BackgroundColorG = inputs[(int)InputId.BackgroundColorG].Eval(context).Value;
            var BackgroundColorB = inputs[(int)InputId.BackgroundColorB].Eval(context).Value;
            var BackgroundColorA = inputs[(int)InputId.BackgroundColorA].Eval(context).Value;
            var BackgroundColor = new Color4(BackgroundColorR, BackgroundColorG, BackgroundColorB, BackgroundColorA);
            var DistToColor = inputs[(int)InputId.DistToColor].Eval(context).Value;
            var GlowColorR = inputs[(int)InputId.GlowColorR].Eval(context).Value;
            var GlowColorG = inputs[(int)InputId.GlowColorG].Eval(context).Value;
            var GlowColorB = inputs[(int)InputId.GlowColorB].Eval(context).Value;
            var GlowColorA = inputs[(int)InputId.GlowColorA].Eval(context).Value;
            var GlowColor = new Color4(GlowColorR, GlowColorG, GlowColorB, GlowColorA);
            var GlowStrength = inputs[(int)InputId.GlowStrength].Eval(context).Value;
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 1, 1, 1));

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                using (var Image2View = new ShaderResourceView(context.D3DDevice, Image2))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Color1").AsVector().Set(new Vector4(Color1R, Color1G, Color1B, Color1A));
                    _effect.GetVariableByName("Color2").AsVector().Set(new Vector4(Color2R, Color2G, Color2B, Color2A));
                    _effect.GetVariableByName("Minrad").AsScalar().Set(Minrad);
                    _effect.GetVariableByName("Farrad").AsScalar().Set(Farrad);
                    _effect.GetVariableByName("Scale").AsScalar().Set(Scale);
                    _effect.GetVariableByName("StepCount").AsScalar().Set(StepCount);
                    _effect.GetVariableByName("StepSize").AsScalar().Set(StepSize);
                    _effect.GetVariableByName("LightPos").AsVector().Set(new Vector3(LightPosX, LightPosY, LightPosZ));
                    _effect.GetVariableByName("Specular").AsVector().Set(new Vector2(SpecularSize, SpecularPower));
                    _effect.GetVariableByName("FogDistance").AsScalar().Set(FogDistance);
                    _effect.GetVariableByName("AmbientOcclusion").AsVector().Set(new Vector2(AmbientOcclusionSize, AmbientOcclusionStrength));
                    _effect.GetVariableByName("AOColor").AsVector().Set(new Vector4(AOColorR, AOColorG, AOColorB, AOColorA));
                    _effect.GetVariableByName("FogDecay").AsScalar().Set(FogDecay);
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("aoSteps").AsScalar().Set(aoSteps);
                    _effect.GetVariableByName("MinDist").AsScalar().Set(MinDist);
                    _effect.GetVariableByName("Image2").AsShaderResource().SetResource(Image2View);
                    _effect.GetVariableByName("Clamping").AsVector().Set(new Vector3(ClampingMin, ClampingMax, ClampingFactor));
                    _effect.GetVariableByName("Fold").AsVector().Set(new Vector2(FoldX, FoldY));
                    _effect.GetVariableByName("Increment").AsVector().Set(new Vector3(IncrementX, IncrementY, IncrementZ));
                    _effect.GetVariableByName("Sphere").AsVector().Set(new Vector3(SphereX, SphereY, SphereZ));
                    _effect.GetVariableByName("SphereRadius").AsScalar().Set(SphereRadius);
                    _effect.GetVariableByName("BackgroundColor").AsVector().Set(new Vector4(BackgroundColorR, BackgroundColorG, BackgroundColorB, BackgroundColorA));
                    _effect.GetVariableByName("DistToColor").AsScalar().Set(DistToColor);
                    _effect.GetVariableByName("GlowColor").AsVector().Set(new Vector4(GlowColorR, GlowColorG, GlowColorB, GlowColorA));
                    _effect.GetVariableByName("GlowStrength").AsScalar().Set(GlowStrength);
                //<<< _setup
                var viewToWorld = Matrix.Invert(context.WorldToCamera*context.CameraProjection);
                _effect.GetVariableByName("ViewToWorld").AsMatrix().SetMatrix(viewToWorld);

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

