//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using


namespace Framefield.Core.ID97431c06_0eda_4291_bc12_7398d79a3e68
{
    public class Class_Concat : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Strings = 0,
            Delimiter = 1
        }
        //<<< _inputids


        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> params
            var StringInputs = inputs[(int)InputId.Strings];
            var Delimiter = inputs[(int)InputId.Delimiter].Eval(context).Text;
            //<<< params

            string result = string.Empty;
            string separator = "";
            for (int i = 0; i < StringInputs.Connections.Count; ++i) {
                result += separator + StringInputs.Connections[i].Eval(context).Text;
                separator = Delimiter;
            }
            context.Text = result;
            
            return context;
        }
    }
}

