//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using Framefield.Core.Profiling;

namespace Framefield.Core.ID58ebb352_91df_4836_b221_1253318f2760
{
    public class Class_AverageFramerate : OperatorPart.Function, Framefield.Core.OperatorPartTraits.ITimeAccessor
    {
        //>>> _inputids
        private enum InputId
        {
            AverageCount = 0
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var AverageCount = inputs[(int)InputId.AverageCount].Eval(context).Value;
            //<<< _params
            //const int FRAME_COUNT = 10;
            context.Value = 0;
            if (TimeLogger.FrameCount > AverageCount)
            {
                var currentFrame = TimeLogger.LastFrame.Value;
                var lastNthFrame = TimeLogger.GetLastNthFrame((int)AverageCount).Value;
                var duration = (float)(currentFrame.StartTime - lastNthFrame.StartTime)/AverageCount;
                if (duration > 0)
                {
                    context.Value = 1.0f/duration;
                }                
            } 
            return context;
        }
    }
}


