//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDea4cd0a7_869f_45c0_ac78_1e254ebd4c1a
{
    public class Class_AddColorOverlay : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image1 = 1,
            ColorAR = 2,
            ColorAG = 3,
            ColorAB = 4,
            ColorAA = 5,
            PositionAX = 6,
            PositionAY = 7,
            ColorBR = 8,
            ColorBG = 9,
            ColorBB = 10,
            ColorBA = 11,
            PositionBX = 12,
            PositionBY = 13,
            ColorCR = 14,
            ColorCG = 15,
            ColorCB = 16,
            ColorCA = 17,
            PositionCX = 18,
            PositionCY = 19,
            ColorDR = 20,
            ColorDG = 21,
            ColorDB = 22,
            ColorDA = 23,
            PositionDX = 24,
            PositionDY = 25,
            Radius = 26,
            Bleed = 27,
            Randomize = 28,
            Seed = 29
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image1 = inputs[(int)InputId.Image1].Eval(context).Image; if (Image1 == null) return context;
            var ColorAR = inputs[(int)InputId.ColorAR].Eval(context).Value;
            var ColorAG = inputs[(int)InputId.ColorAG].Eval(context).Value;
            var ColorAB = inputs[(int)InputId.ColorAB].Eval(context).Value;
            var ColorAA = inputs[(int)InputId.ColorAA].Eval(context).Value;
            var ColorA = new Color4(ColorAR, ColorAG, ColorAB, ColorAA);
            var PositionAX = inputs[(int)InputId.PositionAX].Eval(context).Value;
            var PositionAY = inputs[(int)InputId.PositionAY].Eval(context).Value;
            var PositionA = new Vector2(PositionAX, PositionAY);
            var ColorBR = inputs[(int)InputId.ColorBR].Eval(context).Value;
            var ColorBG = inputs[(int)InputId.ColorBG].Eval(context).Value;
            var ColorBB = inputs[(int)InputId.ColorBB].Eval(context).Value;
            var ColorBA = inputs[(int)InputId.ColorBA].Eval(context).Value;
            var ColorB = new Color4(ColorBR, ColorBG, ColorBB, ColorBA);
            var PositionBX = inputs[(int)InputId.PositionBX].Eval(context).Value;
            var PositionBY = inputs[(int)InputId.PositionBY].Eval(context).Value;
            var PositionB = new Vector2(PositionBX, PositionBY);
            var ColorCR = inputs[(int)InputId.ColorCR].Eval(context).Value;
            var ColorCG = inputs[(int)InputId.ColorCG].Eval(context).Value;
            var ColorCB = inputs[(int)InputId.ColorCB].Eval(context).Value;
            var ColorCA = inputs[(int)InputId.ColorCA].Eval(context).Value;
            var ColorC = new Color4(ColorCR, ColorCG, ColorCB, ColorCA);
            var PositionCX = inputs[(int)InputId.PositionCX].Eval(context).Value;
            var PositionCY = inputs[(int)InputId.PositionCY].Eval(context).Value;
            var PositionC = new Vector2(PositionCX, PositionCY);
            var ColorDR = inputs[(int)InputId.ColorDR].Eval(context).Value;
            var ColorDG = inputs[(int)InputId.ColorDG].Eval(context).Value;
            var ColorDB = inputs[(int)InputId.ColorDB].Eval(context).Value;
            var ColorDA = inputs[(int)InputId.ColorDA].Eval(context).Value;
            var ColorD = new Color4(ColorDR, ColorDG, ColorDB, ColorDA);
            var PositionDX = inputs[(int)InputId.PositionDX].Eval(context).Value;
            var PositionDY = inputs[(int)InputId.PositionDY].Eval(context).Value;
            var PositionD = new Vector2(PositionDX, PositionDY);
            var Radius = inputs[(int)InputId.Radius].Eval(context).Value;
            var Bleed = inputs[(int)InputId.Bleed].Eval(context).Value;
            var Randomize = inputs[(int)InputId.Randomize].Eval(context).Value;
            var Seed = inputs[(int)InputId.Seed].Eval(context).Value;
            //<<< _params
               
            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0.0f));

                if( Randomize > 0) {
                    var rand = new Random( (int)Seed+700);
                    PositionAX += (float)(rand.NextDouble()-0.5f) * Randomize;
                    PositionAY += (float)(rand.NextDouble()-0.5f) * Randomize;
                    PositionBX += (float)(rand.NextDouble()-0.5f) * Randomize;
                    PositionBY += (float)(rand.NextDouble()-0.5f) * Randomize;
                    PositionCX += (float)(rand.NextDouble()-0.5f) * Randomize;
                    PositionCY += (float)(rand.NextDouble()-0.5f) * Randomize;
                    PositionDX += (float)(rand.NextDouble()-0.5f) * Randomize;
                    PositionDY += (float)(rand.NextDouble()-0.5f) * Randomize;
                    
                }

                //>>> _setup
                using (var Image1View = new ShaderResourceView(context.D3DDevice, Image1))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image1").AsShaderResource().SetResource(Image1View);
                    _effect.GetVariableByName("ColorA").AsVector().Set(new Vector4(ColorAR, ColorAG, ColorAB, ColorAA));
                    _effect.GetVariableByName("PositionA").AsVector().Set(new Vector2(PositionAX, PositionAY));
                    _effect.GetVariableByName("ColorB").AsVector().Set(new Vector4(ColorBR, ColorBG, ColorBB, ColorBA));
                    _effect.GetVariableByName("PositionB").AsVector().Set(new Vector2(PositionBX, PositionBY));
                    _effect.GetVariableByName("ColorC").AsVector().Set(new Vector4(ColorCR, ColorCG, ColorCB, ColorCA));
                    _effect.GetVariableByName("PositionC").AsVector().Set(new Vector2(PositionCX, PositionCY));
                    _effect.GetVariableByName("ColorD").AsVector().Set(new Vector4(ColorDR, ColorDG, ColorDB, ColorDA));
                    _effect.GetVariableByName("PositionD").AsVector().Set(new Vector2(PositionDX, PositionDY));
                    _effect.GetVariableByName("Radius").AsScalar().Set(Radius);
                    _effect.GetVariableByName("Bleed").AsScalar().Set(Bleed);
                    _effect.GetVariableByName("Randomize").AsScalar().Set(Randomize);
                    _effect.GetVariableByName("Seed").AsScalar().Set(Seed);
                //<<< _setup
                

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}



