//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID1d8941d4_fe5f_44fe_b8bc_1613b41f7811
{
    public class Class_dof2 : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            Brightness = 2,
            Contrast = 3,
            Size = 4,
            CenterX = 5,
            CenterY = 6,
            NumberofSamples = 7,
            Offset = 8
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {

            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image = inputs[(int)InputId.Image].Eval(context).Image; if (Image == null) return context;
            var Brightness = inputs[(int)InputId.Brightness].Eval(context).Value;
            var Contrast = inputs[(int)InputId.Contrast].Eval(context).Value;
            var Size = inputs[(int)InputId.Size].Eval(context).Value;
            var CenterX = inputs[(int)InputId.CenterX].Eval(context).Value;
            var CenterY = inputs[(int)InputId.CenterY].Eval(context).Value;
            var Center = new Vector2(CenterX, CenterY);
            var NumberofSamples = inputs[(int)InputId.NumberofSamples].Eval(context).Value;
            var Offset = inputs[(int)InputId.Offset].Eval(context).Value;
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(1, 1, 1, 0));

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("Brightness").AsScalar().Set(Brightness);
                    _effect.GetVariableByName("Contrast").AsScalar().Set(Contrast);
                    _effect.GetVariableByName("Size").AsScalar().Set(Size);
                    _effect.GetVariableByName("Center").AsVector().Set(new Vector2(CenterX, CenterY));
                    _effect.GetVariableByName("NumberofSamples").AsScalar().Set(NumberofSamples);
                    _effect.GetVariableByName("Offset").AsScalar().Set(Offset);
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}
