//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDe9e1a314_8192_4072_bf10_351aaa5b3ec2
{
    public class Class_TransformQuat : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            SceneInput = 0,
            TranslateX = 1,
            TranslateY = 2,
            TranslateZ = 3,
            RotateX = 4,
            RotateY = 5,
            RotateZ = 6,
            RotateW = 7,
            ScaleX = 8,
            ScaleY = 9,
            ScaleZ = 10,
            PivotX = 11,
            PivotY = 12,
            PivotZ = 13
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var SceneInput = inputs[(int)InputId.SceneInput];
            var TranslateX = inputs[(int)InputId.TranslateX].Eval(context).Value;
            var TranslateY = inputs[(int)InputId.TranslateY].Eval(context).Value;
            var TranslateZ = inputs[(int)InputId.TranslateZ].Eval(context).Value;
            var Translate = new Vector3(TranslateX, TranslateY, TranslateZ);
            var RotateX = inputs[(int)InputId.RotateX].Eval(context).Value;
            var RotateY = inputs[(int)InputId.RotateY].Eval(context).Value;
            var RotateZ = inputs[(int)InputId.RotateZ].Eval(context).Value;
            var RotateW = inputs[(int)InputId.RotateW].Eval(context).Value;
            var Rotate = new Vector4(RotateX, RotateY, RotateZ, RotateW);
            var ScaleX = inputs[(int)InputId.ScaleX].Eval(context).Value;
            var ScaleY = inputs[(int)InputId.ScaleY].Eval(context).Value;
            var ScaleZ = inputs[(int)InputId.ScaleZ].Eval(context).Value;
            var Scale = new Vector3(ScaleX, ScaleY, ScaleZ);
            var PivotX = inputs[(int)InputId.PivotX].Eval(context).Value;
            var PivotY = inputs[(int)InputId.PivotY].Eval(context).Value;
            var PivotZ = inputs[(int)InputId.PivotZ].Eval(context).Value;
            var Pivot = new Vector3(PivotX, PivotY, PivotZ);
            //<<< _params

            var transform = Matrix.Transformation(new Vector3(), new Quaternion(), Scale, new Vector3(), new Quaternion(Rotate), Translate);
            var prevTransform = context.ObjectTWorld;
            context.ObjectTWorld = transform * prevTransform;

            SceneInput.Eval(context);

            context.ObjectTWorld = prevTransform;
            return context;
        }
    }
}
