using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;

namespace Framefield.Core.ID5222ef16_812f_471d_b152_ef41f45910fd
{
    public class Class_SceneRepeat : OperatorPart.Function
    {
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            var SceneInput = inputs[0];
            var TranslateX = (float) inputs[1].Eval(context).Value;
            var TranslateY = (float) inputs[2].Eval(context).Value;
            var TranslateZ = (float) inputs[3].Eval(context).Value;
            var RotateX = (float) inputs[4].Eval(context).Value;
            var RotateY = (float) inputs[5].Eval(context).Value;
            var RotateZ = (float) inputs[6].Eval(context).Value;
            var ScaleX = (float) inputs[7].Eval(context).Value;
            var ScaleY = (float) inputs[8].Eval(context).Value;
            var ScaleZ = (float) inputs[9].Eval(context).Value;
            var Count = (float) inputs[10].Eval(context).Value;
            //!!automatic generated code ends here
            var translation = new Vector3(TranslateX, TranslateY, TranslateZ);
            var rotation = Quaternion.RotationYawPitchRoll(RotateX / 360.0f * (float)(2.0 * Math.PI),
                                                           RotateY / 360.0f * (float)(2.0 * Math.PI),
                                                           RotateZ / 360.0f * (float)(2.0 * Math.PI));
            var scale = new Vector3(ScaleX, ScaleY, ScaleZ);
            
            var transform = Matrix.Transformation(new Vector3(), new Quaternion(), scale, new Vector3(), rotation, translation);
            
            var prevTransform = context.ObjectTWorld;
            
            for (var i = 0; i < Count; ++i) {
                SceneInput.Eval(context);
                context.ObjectTWorld = transform * context.ObjectTWorld;
            }
            
            context.ObjectTWorld = prevTransform;
            
            //!!automatic generated code starts here
            return context;
        }
    }
}

