//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDa1cc13f7_10dd_4bcb_8773_3720558c4d90
{
    public class Class_RGB2HSL : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image1 = 1
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            return PrepareAndEvalOnChange(context, () =>
            {
                //>>> _params
                var Code = inputs[(int)InputId.Code].Eval(context).Text;
                var Image1 = inputs[(int)InputId.Image1].Eval(context).Image; // Needs to be checked for null!
                //<<< _params

                if(Image1 == null)
                    return;
                    
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                using (var Image1View = new ShaderResourceView(context.D3DDevice, Image1))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image1").AsShaderResource().SetResource(Image1View);
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

