//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using System.IO;
using BmFont;

namespace Framefield.Core.ID4045aca4_ff15_43c4_9e12_f8d17a0171f9
{
    public class Class_LoadBMFont : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            FontPath = 0
        }
        //<<< _inputids

        //>>> _outputids
        private enum OutputId
        {
            FontImage = 0,
            FontInfo = 1
        }
        //<<< _outputids

        public override void Dispose()
        {
            Utilities.DisposeObj(ref _fontImageResource);
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            //>>> _params
            var FontPath = inputs[(int)InputId.FontPath].Eval(context).Text;
            //<<< _params

            if (FontPath == _lastFontPath)
                Changed = false;

            _lastFontPath = FontPath;

            if (Changed)
            {
                Dispose();
                ReadFont(FontPath);

                Changed = false;
            }

            if (_fontImageResource != null)
            {
                switch ((OutputId)outputIdx)
                {
                    case OutputId.FontImage:
                        context.Image = _fontImageResource.Image;
                        break;
                    case OutputId.FontInfo:
                        context.Dynamic = _fontFile;
                        break;
                }
            }
            else
            {
                switch (outputIdx)
                {
                    case (int)OutputId.FontImage:
                        context.Image = null;
                        break;
                    case (int)OutputId.FontInfo:
                        context.Dynamic = null;
                        break;
                }
            }

            return context;
        }

        private void ReadFont(string fontPath)
        {
            var fi = new FileInfo(fontPath);
            if (fi.Extension.ToLower() != ".fnt")
            {
                Logger.Error(this, "No valid font file '{0}'", fontPath);
                return;
            }

            if (!fi.Exists)
            {
                Logger.Error(this, "Font file not found '{0}'", fontPath);
                return;
            }

            _fontFile = FontLoader.Load(fi.FullName);

            var firstPage = _fontFile.Pages[0];
            var fontImagePath = fi.DirectoryName + @"\" + firstPage.File;
            if (!File.Exists(fontImagePath))
            {
                Logger.Error(this, "Font image file not found '{0}'", fontPath);
                return;
            }

            _fontImageResource = ResourceManager.ReadImage(fontImagePath);
        }

        private ImageResource _fontImageResource;
        private string _lastFontPath = string.Empty;
        private FontFile _fontFile;
    }
}

