//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID50d8d1d6_5627_4c87_860f_acbec82a0baa
{
    public class Class_InfoOverlay : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            MaskAspectRatio = 2,
            ShowClamped = 3
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image = inputs[(int)InputId.Image].Eval(context).Image; if (Image == null) return context;
            var MaskAspectRatio = inputs[(int)InputId.MaskAspectRatio].Eval(context).Value;
            var ShowClamped = inputs[(int)InputId.ShowClamped].Eval(context).Value;
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 1));

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("MaskAspectRatio").AsScalar().Set(MaskAspectRatio);
                    _effect.GetVariableByName("ShowClamped").AsScalar().Set(ShowClamped);
                //<<< _setup
                
                _effect.GetVariableByName("UpdateCount").AsScalar().Set(_updateCount++);

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }
        
        int _updateCount;

    }
}

