//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID08a150e6_2d6d_4a5d_b203_ea9e417e71d0
{
    public class Class_GrayScottDiffusion1 : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            DiffusionX = 2,
            DiffusionY = 3,
            FValue = 4,
            kValue = 5,
            FDx = 6,
            kDx = 7,
            ResetTrigger = 8
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image = inputs[(int)InputId.Image].Eval(context).Image; // Needs to be checked for null!
            var DiffusionX = inputs[(int)InputId.DiffusionX].Eval(context).Value;
            var DiffusionY = inputs[(int)InputId.DiffusionY].Eval(context).Value;
            var Diffusion = new Vector2(DiffusionX, DiffusionY);
            var FValue = inputs[(int)InputId.FValue].Eval(context).Value;
            var FDx = inputs[(int)InputId.FDx].Eval(context).Value;
            var F = new Vector2(FValue, FDx);
            var kValue = inputs[(int)InputId.kValue].Eval(context).Value;
            var kDx = inputs[(int)InputId.kDx].Eval(context).Value;
            var k = new Vector2(kValue, kDx);
            var ResetTrigger = inputs[(int)InputId.ResetTrigger].Eval(context).Value;
            //<<< _params


            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("Diffusion").AsVector().Set(new Vector2(DiffusionX, DiffusionY));
                    _effect.GetVariableByName("F").AsVector().Set(new Vector2(FValue, FDx));
                    _effect.GetVariableByName("k").AsVector().Set(new Vector2(kValue, kDx));
                    _effect.GetVariableByName("ResetTrigger").AsScalar().Set(ResetTrigger);
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

