//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID5554f477_94b3_4c16_bbf2_6bd1ac0215fc
{
    public class Class_DistributedRandom : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            A = 0,
            AWeight = 1,
            B = 2,
            BWeight = 3,
            Seed = 4
        }
        //<<< _inputids
        
        
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            //>>> _params
            var A = inputs[(int)InputId.A].Eval(context).Value;
            var AWeight = inputs[(int)InputId.AWeight].Eval(context).Value;
            var B = inputs[(int)InputId.B].Eval(context).Value;
            var BWeight = inputs[(int)InputId.BWeight].Eval(context).Value;
            var Seed = inputs[(int)InputId.Seed].Eval(context).Value;
            //<<< _params
            
            //>>> function
            var rand = new Random((int)(Seed*Seed/1.21f+23423f));
            var xx= rand.NextDouble();
            xx= rand.NextDouble();
            rand = new Random((int)(xx*223+Seed));
            float t = (float)rand.NextDouble();
            
            
            var fadeA= (float)Math.Pow( t, Math.Pow( 0.5, -AWeight));
            var fadeB= (float)Math.Pow( 1-t, Math.Pow( 0.5, -BWeight));
            
            var v= fadeA * (1 - t) + t * (1-fadeB);
            
            context.Value= (B-A)* v+A;
            //<<< function
            
            return context;
        }
    }
}

