//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDf478436d_3c85_4469_b8a1_10900bbfa061
{
    public class Class_Counter : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            CountTrigger = 0,
            ResetTrigger = 1
        }
        //<<< _inputids
        
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var CountTrigger = inputs[(int)InputId.CountTrigger].Eval(context).Value;
            var ResetTrigger = inputs[(int)InputId.ResetTrigger].Eval(context).Value;
            //<<< _params
            
            
            bool flankDetected = CountTrigger >= 0.5 && _oldTrigger <= 0.5;
            _oldTrigger = CountTrigger;
            
            if( flankDetected) {
            //if( CountTrigger != _lastValue && CountTrigger == 1.0) {
                _count++;
            }
            
            if( ResetTrigger == 1.0) {
                _count = 0;
            }
            _lastValue= CountTrigger;
            context.Value= _count;
            return context;
        }
        
        int _count = 0;
        float _lastValue= float.NaN;
        float _oldTrigger;
    }
}

