import QtQuick 2.0
import Sailfish.Silica 1.0

import MemoryLeek 1.0

Page
{
	property var samples

	id: page

	ResultPageViewModel
	{
		id: context
	}

	SilicaListView
	{
		anchors
		{
			fill: parent
		}

		model: context.results
		header: PageHeader
		{
			title: "Results"
		}

		ViewPlaceholder
		{
			enabled: context.isEmpty
			hintText: "No matching tools found"
		}

		delegate: BackgroundItem
		{
			width: ListView.view.width
			height: rect.height + 75

			onClicked: pageStack.push("InformationPage.qml", { "tool": modelData.tool })

			AudioDataVisualizer
			{
				data: page.samples
				width: parent.width
				height: 150
				color: Theme.secondaryColor
				highlightColor: Theme.highlightColor
				gaps: 5
				opacity: 0.7
				offset: modelData.offset
				length: modelData.match
			}

			Rectangle
			{
				id: rect
				width: parent.width
				height: label.height + (Theme.paddingLarge * 2)
				color: Theme.highlightDimmerColor
				opacity: 0.7
				y: 75

				Rectangle
				{
					width: parent.width
					height: 5
					color: Theme.highlightDimmerColor
				}
			}

			Item
			{
				y: 80
				width: parent.width

				Row
				{
					y: Theme.paddingLarge

					anchors
					{
						left: parent.left
						right: match.left
						margins: Theme.paddingLarge
					}

					id: label
					spacing: Theme.paddingLarge

					Image
					{
						id: image
						source: TypeToImageMapping.getImage(modelData.tool.type)
					}

					Column
					{
						anchors
						{
							verticalCenter: image.verticalCenter
						}

						width: parent.width - image.width - Theme.paddingLarge

						Label
						{

							color: Theme.primaryColor
							text: "%1 i %2".arg(modelData.tool.type).arg(modelData.material.name)
							elide: Text.ElideRight
							width: parent.width
						}

						Label
						{
							color: Theme.secondaryColor
							text: "%1 %2".arg(modelData.tool.brand).arg(modelData.tool.model)
							elide: Text.ElideRight
							width: parent.width
						}
					}
				}

				Label
				{
					anchors
					{
						verticalCenter: label.verticalCenter
						right: parent.right
						margins: Theme.paddingLarge
					}

					id: match
					color: Theme.primaryColor
					text: "%1%".arg(modelData.match)

					font
					{
						pixelSize: Theme.fontSizeLarge
					}
				}
			}
		}
	}
}
