import QtQuick 2.0
import Sailfish.Silica 1.0

import MemoryLeek 1.0

Page
{
	property var samples

	id: page

	MatchingPageViewModel
	{
		id: context
		data: page.samples

		onAnalyzeComplete: pageStack.replace("ResultPage.qml", { "samples": page.samples })
	}

	Column
	{
		anchors
		{
			centerIn: parent
		}

		spacing: 40

		BusyIndicator
		{
			anchors
			{
				horizontalCenter: parent.horizontalCenter
			}

			size: BusyIndicatorSize.Large
			running: true
		}

		Label
		{
			anchors
			{
				horizontalCenter: parent.horizontalCenter
			}

			font
			{
				pixelSize: Theme.fontSizeLarge
			}

			text: "Processing"
		}
	}
}
