import QtQuick 2.0
import Sailfish.Silica 1.0

import ".."

Page
{
	property var tool

	Column
	{
		width: parent.width

		PageHeader
		{
			title: "%1 %2".arg(tool.brand).arg(tool.model)
		}

		Rectangle
		{
			color: "white"
			width: parent.width
			height: childrenRect.height
			opacity: 0.65

			Image
			{
				anchors
				{
					horizontalCenter: parent.horizontalCenter
				}

				source: "qrc:///thumbs/%1".arg(tool.image)
			}
		}

		Item
		{
			width: parent.width
			height: Theme.paddingLarge
		}

		DetailItem
		{
			label: "Type"
			value: tool.type
		}

		DetailItem
		{
			label: "Power"
			value: tool.power
		}

		DetailItem
		{
			label: "Color"
			value: tool.color
		}

		Item
		{
			width: parent.width
			height: Theme.paddingLarge
		}

		SectionHeader
		{
			text: "Detailed information"
			horizontalAlignment: Text.AlignLeft
		}

		Label
		{
			text: tool.info
			width: parent.width - (Theme.paddingLarge * 2)
			x: Theme.paddingLarge
			wrapMode: Text.Wrap
			color: Theme.secondaryColor

			font
			{
				pixelSize: Theme.fontSizeSmall
			}
		}
	}
}
