package kamikaze3.oventemp;

import android.app.Activity;
import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.widget.TextView;

import java.util.List;

public class MainActivity extends Activity implements SensorEventListener {

    private static final int MINIMUM_TEMPERATURE = 180;

    private SensorManager sensorManager;
    private Sensor temperatureSensor;
    private TextView tempView;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        tempView = (TextView) findViewById(R.id.temp_view);

        sensorManager = (SensorManager) getSystemService(Context.SENSOR_SERVICE);
        temperatureSensor = sensorManager.getDefaultSensor(65536);
        if (temperatureSensor != null)
            sensorManager.registerListener((SensorEventListener) this, temperatureSensor, SensorManager.SENSOR_DELAY_NORMAL);
        else
            System.out.println("Not working");
    }

    @Override
    public void onSensorChanged(SensorEvent event) {
        float value = event.values[0];
        int intVal = (int) value;

        if (intVal > this.MINIMUM_TEMPERATURE) {
            this.tempView.setText((int)value + "c");
            this.tempView.setTextSize(100);
        }
        else {
            this.tempView.setText("A preheated oven is required.");
            this.tempView.setTextSize(50);
        }
    }

    @Override
    public void onAccuracyChanged(Sensor sensor, int accuracy) {
        // Naaaathing
    }

    @Override
    protected void onResume() {
        super.onResume();
        temperatureSensor = sensorManager.getDefaultSensor(65536);
        if (temperatureSensor != null)
            sensorManager.registerListener((SensorEventListener) this, temperatureSensor, SensorManager.SENSOR_DELAY_NORMAL);
    }
}
