import processing.sound.*;

float bx;
float by;
int boxW = 250;
int boxH = 50;
boolean overBox = false;
boolean locked = false;
PImage img;

SoundFile[] files;

void setup() {
  size(250, 800);
  img = loadImage("bg.png");
  bx = width/2.0;
  by = height/2.0;
  rectMode(RADIUS);
  rect(bx, by, boxW, boxH);
  
  
  
  // Create an array of 5 empty soundfiles
  files = new SoundFile[2];

  for (int i = 0; i < files.length; i++) {
    files[i] = new SoundFile(this, (i+1) + ".wav");
  }
}

void draw() {
  background(0);
  // If the determined trigger moment in time matches up with 
  // the computer clock events get triggered.
  // Test if the cursor is over the box 
  if (mouseX > bx-boxW && mouseX < bx+boxW && 
      mouseY > by-boxH && mouseY < by+boxH) {
    overBox = true;  
    if(!locked) { 
      
      stroke(255);
      strokeWeight(8);
      fill(0, 153, 255);
    } 
  } else {
    stroke(0, 153, 255);
    fill(0, 153, 255);
    overBox = false;
  }
  
  // Draw the box
  rect(bx, by, boxW, boxH);
}
  
void mousePressed() {
  files[0].stop();
  if(overBox) { 
    locked = true; 
    fill(0, 204, 102);
    files[1].play();
  } else {
    locked = false;
  }
}

void mouseDragged() {
  
  if(locked) {
    bx = mouseX; 
    by = mouseY;
    if(bx > width-boxW){
      bx = width-(boxW);
    } 
    if(bx < 0+boxW){
      bx = 0+(boxW/2);
    }
    if(by > height-boxH){
      by = height-(boxH);
    } 
    if(by < 0+boxH){
      by = 0+(boxH);
    }
  }
}

void mouseReleased() {
  locked = false;
  files[1].stop();
  files[0].play(250/by);
}