/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.annotation.TargetApi;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.UserManager;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.R;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.internal.zzy;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.common.util.zzl;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.common.util.zzx;
import com.google.android.gms.common.zzc;
import com.google.android.gms.common.zzd;
import com.google.android.gms.common.zzf;
import com.google.android.gms.internal.zzpv;
import com.google.android.gms.internal.zzpw;
import java.io.InputStream;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;

public class zze {
    @Deprecated
    public static final int GOOGLE_PLAY_SERVICES_VERSION_CODE = zze.zzqZ();
    @Deprecated
    public static final String GOOGLE_PLAY_SERVICES_PACKAGE = "com.google.android.gms";
    public static final String GOOGLE_PLAY_STORE_PACKAGE = "com.android.vending";
    public static boolean zzaku = false;
    public static boolean zzakv = false;
    static boolean zzakw = false;
    private static String zzakx = null;
    private static int zzaky = 0;
    private static boolean zzakz = false;
    static final AtomicBoolean zzakA = new AtomicBoolean();
    private static final AtomicBoolean zzakB = new AtomicBoolean();

    zze() {
    }

    private static int zzqZ() {
        return com.google.android.gms.common.internal.zze.zzaqR;
    }

    @Deprecated
    public static String getErrorString(int n) {
        return ConnectionResult.getStatusString(n);
    }

    @Deprecated
    public static int isGooglePlayServicesAvailable(Context context) {
        Resources resources;
        PackageManager packageManager = context.getPackageManager();
        try {
            resources = context.getResources();
            resources.getString(R.string.common_google_play_services_unknown_issue);
        }
        catch (Throwable throwable) {
            Log.e((String)"GooglePlayServicesUtil", (String)"The Google Play services resources were not found. Check your project configuration to ensure that the resources are included.");
        }
        if (!GOOGLE_PLAY_SERVICES_PACKAGE.equals(context.getPackageName())) {
            zze.zzaj(context);
        }
        try {
            resources = packageManager.getPackageInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 64);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services is missing.");
            return 1;
        }
        zzf zzf2 = zzf.zzaq(context);
        if (zzi.zzaB(context)) {
            if (zzf2.zza((PackageInfo)resources, zzd.zzd.zzakt) == null) {
                Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services signature invalid.");
                return 9;
            }
        } else {
            try {
                PackageInfo packageInfo = packageManager.getPackageInfo(GOOGLE_PLAY_STORE_PACKAGE, 8256);
                zzd.zza zza2 = zzf2.zza(packageInfo, zzd.zzd.zzakt);
                if (zza2 == null) {
                    Log.w((String)"GooglePlayServicesUtil", (String)"Google Play Store signature invalid.");
                    return 9;
                }
                if (zzf2.zza((PackageInfo)resources, zza2) == null) {
                    Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services signature invalid.");
                    return 9;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.w((String)"GooglePlayServicesUtil", (String)"Google Play Store is neither installed nor updating.");
                return 9;
            }
        }
        int n = zzl.zzcx(GOOGLE_PLAY_SERVICES_VERSION_CODE);
        int n2 = zzl.zzcx(resources.versionCode);
        if (n2 < n) {
            int n3 = GOOGLE_PLAY_SERVICES_VERSION_CODE;
            int n4 = resources.versionCode;
            Log.w((String)"GooglePlayServicesUtil", (String)new StringBuilder(77).append("Google Play services out of date.  Requires ").append(n3).append(" but found ").append(n4).toString());
            return 2;
        }
        ApplicationInfo applicationInfo = resources.applicationInfo;
        if (applicationInfo == null) {
            try {
                applicationInfo = packageManager.getApplicationInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.wtf((String)"GooglePlayServicesUtil", (String)"Google Play services missing when getting application info.", (Throwable)nameNotFoundException);
                return 1;
            }
        }
        if (!applicationInfo.enabled) {
            return 3;
        }
        return 0;
    }

    @Deprecated
    public static void zzaa(Context context) throws GooglePlayServicesRepairableException, GooglePlayServicesNotAvailableException {
        int n = zzc.zzqV().isGooglePlayServicesAvailable(context);
        if (n != 0) {
            Intent intent = zzc.zzqV().zza(context, n, "e");
            Log.e((String)"GooglePlayServicesUtil", (String)new StringBuilder(57).append("GooglePlayServices not available due to error ").append(n).toString());
            if (intent == null) {
                throw new GooglePlayServicesNotAvailableException(n);
            }
            throw new GooglePlayServicesRepairableException(n, "Google Play Services not available", intent);
        }
    }

    private static void zzaj(Context context) {
        if (zzakB.get()) {
            return;
        }
        zze.zzao(context);
        if (zzaky == 0) {
            throw new IllegalStateException("A required meta-data tag in your app's AndroidManifest.xml does not exist.  You must have the following declaration within the <application> element:     <meta-data android:name=\"com.google.android.gms.version\" android:value=\"@integer/google_play_services_version\" />");
        }
        if (zzaky != GOOGLE_PLAY_SERVICES_VERSION_CODE) {
            int n = GOOGLE_PLAY_SERVICES_VERSION_CODE;
            int n2 = zzaky;
            String string2 = String.valueOf("com.google.android.gms.version");
            throw new IllegalStateException(new StringBuilder(290 + String.valueOf(string2).length()).append("The meta-data tag in your app's AndroidManifest.xml does not have the right value.  Expected ").append(n).append(" but found ").append(n2).append(".  You must have the following declaration within the <application> element:     <meta-data android:name=\"").append(string2).append("\" android:value=\"@integer/google_play_services_version\" />").toString());
        }
    }

    @Deprecated
    public static boolean zze(Context context, int n) {
        return zzx.zze(context, n);
    }

    @Deprecated
    public static Intent zzbC(int n) {
        return zzc.zzqV().zza(null, n, null);
    }

    @Deprecated
    public static boolean zzra() {
        return "user".equals(Build.TYPE);
    }

    public static boolean zzak(Context context) {
        zze.zzao(context);
        return zzakw;
    }

    public static boolean zzal(Context context) {
        return zze.zzak(context) || !zze.zzra();
    }

    static boolean zzbD(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 18: 
            case 42: {
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static PendingIntent getErrorPendingIntent(int n, Context context, int n2) {
        return zzc.zzqV().getErrorResolutionPendingIntent(context, n, n2);
    }

    @Deprecated
    public static void zzag(Context context) {
        if (zzakA.getAndSet(true)) {
            return;
        }
        try {
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            notificationManager.cancel(10436);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Deprecated
    public static boolean isUserRecoverableError(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static String getOpenSourceSoftwareLicenseInfo(Context context) {
        String string2;
        block9: {
            Uri uri = new Uri.Builder().scheme("android.resource").authority(GOOGLE_PLAY_SERVICES_PACKAGE).appendPath("raw").appendPath("third_party_licenses").build();
            InputStream inputStream = context.getContentResolver().openInputStream(uri);
            try {
                string2 = new Scanner(inputStream).useDelimiter("\\A").next();
                if (inputStream == null) break block9;
            }
            catch (NoSuchElementException noSuchElementException) {
                block10: {
                    try {
                        Object var4_6 = null;
                        if (inputStream == null) break block10;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            throw throwable;
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    }
                    inputStream.close();
                }
                return null;
            }
            inputStream.close();
        }
        return string2;
    }

    public static Resources getRemoteResource(Context context) {
        try {
            return context.getPackageManager().getResourcesForApplication(GOOGLE_PLAY_SERVICES_PACKAGE);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    public static Context getRemoteContext(Context context) {
        try {
            return context.createPackageContext(GOOGLE_PLAY_SERVICES_PACKAGE, 3);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    public static String zzam(Context context) {
        String string2 = context.getApplicationInfo().name;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            ApplicationInfo applicationInfo;
            string2 = context.getPackageName();
            PackageManager packageManager = context.getApplicationContext().getPackageManager();
            try {
                applicationInfo = zzpw.zzaH(context).getApplicationInfo(context.getPackageName(), 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                applicationInfo = null;
            }
            if (applicationInfo != null) {
                string2 = packageManager.getApplicationLabel(applicationInfo).toString();
            }
        }
        return string2;
    }

    @Deprecated
    public static int zzae(Context context) {
        PackageInfo packageInfo;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services is missing.");
            return 0;
        }
        return packageInfo.versionCode;
    }

    @Deprecated
    public static boolean zzc(Context context, int n) {
        if (n == 18) {
            return true;
        }
        if (n == 1) {
            return zze.zzk(context, GOOGLE_PLAY_SERVICES_PACKAGE);
        }
        return false;
    }

    @Deprecated
    public static boolean zzd(Context context, int n) {
        if (n == 9) {
            return zze.zzk(context, GOOGLE_PLAY_STORE_PACKAGE);
        }
        return false;
    }

    @TargetApi(value=21)
    static boolean zzk(Context context, String string2) {
        List list;
        if (zzs.zzvg()) {
            list = context.getPackageManager().getPackageInstaller().getAllSessions();
            for (PackageInstaller.SessionInfo sessionInfo : list) {
                if (!string2.equals(sessionInfo.getAppPackageName())) continue;
                return true;
            }
        }
        if (zze.zzan(context)) {
            return false;
        }
        list = context.getPackageManager();
        try {
            ApplicationInfo applicationInfo = list.getApplicationInfo(string2, 8192);
            return applicationInfo.enabled;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    @TargetApi(value=18)
    public static boolean zzan(Context context) {
        Bundle bundle;
        return zzs.zzvd() && (bundle = ((UserManager)context.getSystemService("user")).getApplicationRestrictions(context.getPackageName())) != null && "true".equals(bundle.getString("restricted_profile"));
    }

    private static void zzao(Context context) {
        if (!zzakz) {
            zze.zzap(context);
        }
    }

    private static void zzap(Context context) {
        try {
            zzakx = context.getPackageName();
            zzpv zzpv2 = zzpw.zzaH(context);
            zzaky = zzy.zzax(context);
            PackageInfo packageInfo = zzpv2.getPackageInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 64);
            zzakw = packageInfo != null && zzf.zzaq(context).zza(packageInfo, zzd.zzd.zzakt[1]) != null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)"GooglePlayServicesUtil", (String)"Cannot find Google Play services package name.", (Throwable)nameNotFoundException);
        }
        finally {
            zzakz = true;
        }
    }
}

