/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.images.zzb;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzz;
import org.json.JSONException;
import org.json.JSONObject;

public final class WebImage
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<WebImage> CREATOR = new zzb();
    private final int mVersionCode;
    private final Uri zzapT;
    private final int zzpi;
    private final int zzpj;

    WebImage(int n, Uri uri, int n2, int n3) {
        this.mVersionCode = n;
        this.zzapT = uri;
        this.zzpi = n2;
        this.zzpj = n3;
    }

    public WebImage(Uri uri, int n, int n2) throws IllegalArgumentException {
        this(1, uri, n, n2);
        if (uri == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("width and height must not be negative");
        }
    }

    public WebImage(Uri uri) throws IllegalArgumentException {
        this(uri, 0, 0);
    }

    public WebImage(JSONObject jSONObject) throws IllegalArgumentException {
        this(WebImage.zzl(jSONObject), jSONObject.optInt("width", 0), jSONObject.optInt("height", 0));
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    private static Uri zzl(JSONObject jSONObject) {
        Uri uri = null;
        if (jSONObject.has("url")) {
            try {
                uri = Uri.parse((String)jSONObject.getString("url"));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return uri;
    }

    public Uri getUrl() {
        return this.zzapT;
    }

    public int getWidth() {
        return this.zzpi;
    }

    public int getHeight() {
        return this.zzpj;
    }

    public String toString() {
        return String.format("Image %dx%d %s", this.zzpi, this.zzpj, this.zzapT.toString());
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("url", (Object)this.zzapT.toString());
            jSONObject.put("width", this.zzpi);
            jSONObject.put("height", this.zzpj);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof WebImage)) {
            return false;
        }
        WebImage webImage = (WebImage)((Object)object);
        return zzz.equal((Object)this.zzapT, (Object)webImage.zzapT) && this.zzpi == webImage.zzpi && this.zzpj == webImage.zzpj;
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.zzapT, this.zzpi, this.zzpj});
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }
}

