package util;

import java.util.Arrays;

public class GaussianBlur {

	public static float[][] blur(float[][] input, float r) {
		float[] bxs = boxesForGauss(r, 5);
		System.out.println(Arrays.toString(bxs));
		
		float[][] output;
		output = boxBlur(input, (bxs[0] - 1) / 2);
		output = boxBlur(output, (bxs[1] - 1) / 2);
		output = boxBlur(output, (bxs[2] - 1) / 2);
		
		return output;
	}
	
	private static float[][] boxBlur(float[][] input, float r) {
		float[][] output = new float[input.length][input[0].length];
		
	    output = boxBlurH(input, r);
	    output = boxBlurT(output, r);
		
		return output;
	}
	
	private static float[][] boxBlurH(float[][] input, float r) {
		float[][] output = new float[input.length][input[0].length];
		
		int w = input.length;
		int h = input[0].length;
		
		for(int i = 0; i < h; i++) {
	        for(int j = 0; j < w; j++) {
	            int val = 0;
	            for(float ix = j - r; ix < j + r + 1; ix++) {
	                int x = (int) Math.min(w - 1, Math.max(0, ix));
	                val += input[x][i];
	            }
	            output[j][i] = val/(r+r+1);
	        }
		}
		
		return output;
	}
	
	private static float[][] boxBlurT(float[][] input, float r) {
		float[][] output = new float[input.length][input[0].length];
		
		int w = input.length;
		int h = input[0].length;
		
		for(int i = 0; i < h; i++) {
	        for(int j=0; j < w; j++) {
	            int val = 0;
	            for(float iy = i - r; iy < i + r + 1; iy++) {
	                int y = (int) Math.min(h - 1, Math.max(0, iy));
	                val += input[j][y];
	            }
	            output[j][i] = val/(r+r+1);
	        }
		}
	        
		return output;
	}
	
	private static float[] boxesForGauss(float sigma, int n) {
		float wIdeal = (float) Math.sqrt((12 * sigma * sigma / n) + 1);
	    float wl = (float) Math.floor(wIdeal);  
	    if(wl % 2 == 0) {
	    	wl--;
	    }
	    float wu = wl + 2;
					
	    float mIdeal = (12 * sigma * sigma - n * wl * wl - 4 * n * wl - 3 * n) / (-4 * wl - 4);
	    float m = Math.round(mIdeal);
		
	    float[] sizes = new float[n];
	    for(int i = 0; i < n; i++) {
	    	sizes[i] = i < m ? wl : wu;
	    }
	    return sizes;
	}
}
