/*
 * Decompiled with CFR 0.152.
 */
package ai;

import bot.Bot;
import game.Map;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import util.Position;

public class MiniMax {
    private Map map;
    private int depth;
    private Node root;
    private int nodes = 0;

    public MiniMax(Map map, int depth) {
        this.map = map;
        this.depth = depth;
    }

    public void calculateTree(Bot bot) {
        long time = System.currentTimeMillis();
        this.nodes = 0;
        Node root = new Node();
        root.position = bot.ghost.position;
        root.children = this.generateChildren(this.map, root, bot.ghost.position);
        for (Node child : root.children) {
            child.score = this.minimax(this.map, child, this.depth, NodeType.MIN);
        }
        this.root = root;
        System.out.println("Created " + this.nodes + " nodes in " + (System.currentTimeMillis() - time) + " ms.");
    }

    private float minimax(Map map, Node node, int depth, NodeType type) {
        if (depth == 0) {
            return node.score;
        }
        float v = -2.1474836E9f;
        List<Node> children = this.generateChildren(map, node, node.position);
        for (Node child : children) {
            v = Math.max(v, this.minimax(map, child, depth - 1, NodeType.MIN));
        }
        return v;
    }

    private List<Node> generateChildren(Map map, Node node, Position<Integer, Integer> position) {
        ArrayList<Node> children = new ArrayList<Node>();
        List<Bot.Direction> directions = map.getAvailableMoves(position);
        for (Bot.Direction direction : directions) {
            Position<Integer, Integer> p = Map.getPosition(position, direction);
            Node child = new Node();
            child.direction = direction;
            child.position = p;
            child.score = map.calculateScore(position) + node.score;
            children.add(child);
        }
        return children;
    }

    public Bot.Direction getBestDirection() {
        if (this.root == null || this.root.children == null) {
            return null;
        }
        float bestScore = -2.1474836E9f;
        ArrayList<Node> potential = new ArrayList<Node>();
        for (Node node : this.root.children) {
            if (node.score > bestScore && node.score > 0.0f) {
                potential.clear();
                potential.add(node);
                bestScore = node.score;
                continue;
            }
            if (node.score != bestScore) continue;
            potential.add(node);
        }
        if (potential.isEmpty()) {
            return this.findNearest(this.root);
        }
        Node best = (Node)potential.get(new Random().nextInt(potential.size()));
        return best.direction;
    }

    private Bot.Direction findNearest(Node root) {
        Position<Integer, Integer> p = root.position;
        Map.ObstacleType[][] obstacles = this.map.obstacles;
        ArrayList<Node> visited = new ArrayList<Node>();
        Node[][] nodes = new Node[obstacles.length][obstacles[0].length];
        int x = 0;
        while (x < nodes.length) {
            int y = 0;
            while (y < nodes[0].length) {
                nodes[x][y] = new Node();
                nodes[x][y].position = new Position<Integer, Integer>(x, y);
                ++y;
            }
            ++x;
        }
        LinkedList<Node> queue = new LinkedList<Node>();
        queue.add(nodes[(Integer)p.x][(Integer)p.y]);
        while (!queue.isEmpty()) {
            Node n = (Node)queue.pop();
            if (obstacles[(Integer)n.position.x][(Integer)n.position.y] == Map.ObstacleType.WALL) continue;
            if (obstacles[(Integer)n.position.x][(Integer)n.position.y] == Map.ObstacleType.PELLET || obstacles[(Integer)n.position.x][(Integer)n.position.y] == Map.ObstacleType.SUPERPELLET) {
                Bot.Direction direction = null;
                while (n.parent != null) {
                    n = n.parent;
                    if (n.direction == null) continue;
                    direction = n.direction;
                }
                return direction;
            }
            try {
                Node up = nodes[(Integer)n.position.x][(Integer)n.position.y - 1];
                if (!visited.contains(up)) {
                    up.parent = n;
                    up.direction = Bot.Direction.UP;
                    queue.add(up);
                }
            }
            catch (Exception up) {
                // empty catch block
            }
            try {
                Node down = nodes[(Integer)n.position.x][(Integer)n.position.y + 1];
                if (!visited.contains(down)) {
                    down.parent = n;
                    down.direction = Bot.Direction.DOWN;
                    queue.add(down);
                }
            }
            catch (Exception down) {
                // empty catch block
            }
            try {
                Node left = nodes[(Integer)n.position.x - 1][(Integer)n.position.y];
                if (!visited.contains(left)) {
                    left.parent = n;
                    left.direction = Bot.Direction.LEFT;
                    queue.add(left);
                }
            }
            catch (Exception left) {
                // empty catch block
            }
            try {
                Node right = nodes[(Integer)n.position.x + 1][(Integer)n.position.y];
                if (!visited.contains(right)) {
                    right.parent = n;
                    right.direction = Bot.Direction.RIGHT;
                    queue.add(right);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            visited.add(n);
        }
        return null;
    }

    private class Node {
        public Node parent;
        public List<Node> children;
        public Bot.Direction direction;
        public Position<Integer, Integer> position;
        public float score;

        public Node() {
            MiniMax miniMax2 = MiniMax.this;
            miniMax2.nodes = miniMax2.nodes + 1;
        }
    }

    public static enum NodeType {
        MAX,
        MIN;

    }
}

