package NiosHD


import com.fasterxml.jackson.databind.DeserializationFeature
import com.fasterxml.jackson.module.kotlin.jacksonObjectMapper
import com.fasterxml.jackson.module.kotlin.readValue
import java.io.BufferedReader
import java.io.InputStreamReader
import java.net.Socket


/**
 * Created by nios on 14.04.17.
 */
class NiosHD {
}



val skt = Socket("localhost", 54321)
//val NiosHD.getSkt = Socket("88.92.102.218", 54321)
//val NiosHD.getSkt = Socket("88.92.32.34", 54321)

// classes for json parsing
//----------------------------
data class mapClass(val content:List<String>, val height:Int, val pelletsleft:Int, val width:Int)
data class playerClass(val id:Int, val isdangerous:Boolean, val score:Int, val x:Int, val y:Int)
data class gamestateClass(var map: mapClass, val others:List<playerClass>, var you: playerClass)

data class startDataClass(val map: mapClass, val messagetype:String, val you: playerClass)
data class gameDataClass(var gamestate: gamestateClass?, val messagetype:String)

// arrays for map
//-------------------------------------
var mapHeight : Int = 0
var mapWidth : Int = 0
var mapSize : Int = 0

var wallTiles : Array<Boolean>? = null
var doorTiles : Array<Boolean>? = null
var pelletTiles : Array<Boolean>? = null
var superPelletTiles : Array<Boolean>? = null

var vladMap  : Array<Int>? = null


enum class Direction {
    UP, DOWN, LEFT, RIGHT, NONE
}

data class checkMoveReturn(var direction: Direction, var iteration : Int, var iteration_hit : Int)

fun checkMoveLow(X:Int, Y:Int, iteration:Int) : checkMoveReturn {

    var newX = 0
    var newY = 0

    // CHECK FOR o
    //-----------------------

    //check left
    if(X == 0) {
        newX = mapWidth
    } else {
        newX = X -1
    }
    newY = Y

    if (pelletTiles!![newY* mapWidth +newX]) {
        return checkMoveReturn(Direction.LEFT, iteration, iteration)
    }

    //check right
    if(X == mapWidth) {
        newX = 0
    } else {
        newX = X + 1
    }
    newY = Y

    if (pelletTiles!![newY* mapWidth +newX]) {
        return checkMoveReturn(Direction.RIGHT, iteration, iteration)
    }

    //check up
    if(Y == 0) {
        newY = mapHeight
    } else {
        newY = Y - 1
    }
    newX = X

    if (pelletTiles!![newY* mapWidth +newX]) {
        return checkMoveReturn(Direction.UP, iteration, iteration)
    }

    //check down
    if(Y == mapHeight) {
        newY = 0
    } else {
        newY = Y + 1
    }
    newX = X

    if (pelletTiles!![newY* mapWidth +newX]) {
        return checkMoveReturn(Direction.DOWN, iteration, iteration)
    }

    var bestCheckMove : checkMoveReturn = checkMoveReturn(Direction.NONE, 255, 255)
    var bestCheckMoveDirection : Direction = Direction.NONE

    // CHECK FOR _
    //-----------------------

    //check left
    if(X == 0) {
        newX = mapWidth
    } else {
        newX = X -1
    }
    newY = Y

    if (!wallTiles!![newY* mapWidth +newX]) {
        if(vladMap!![newY* mapWidth +newX] > iteration + 1) {
            vladMap!![newY * mapWidth + newX] = iteration + 1
            val CheckMoveTmp = checkMoveLow(newX, newY, iteration + 1)
            if (CheckMoveTmp.iteration_hit < bestCheckMove.iteration_hit && CheckMoveTmp.direction != Direction.NONE) {
                bestCheckMove = CheckMoveTmp
                bestCheckMoveDirection = Direction.LEFT
            }
        }
    }


    //check right
    if(X == mapWidth) {
        newX = 0
    } else {
        newX = X + 1
    }
    newY = Y

    if (!wallTiles!![newY* mapWidth +newX]) {
        if(vladMap!![newY* mapWidth +newX] > iteration + 1) {
            vladMap!![newY* mapWidth +newX] = iteration + 1
            val CheckMoveTmp = checkMoveLow(newX, newY, iteration + 1)
            if (CheckMoveTmp.iteration_hit < bestCheckMove.iteration_hit && CheckMoveTmp.direction != Direction.NONE) {
                bestCheckMove = CheckMoveTmp
                bestCheckMoveDirection = Direction.RIGHT
            }
        }
    }


    //check up
    if(Y == 0) {
        newY = mapHeight
    } else {
        newY = Y - 1
    }
    newX = X

    if (!wallTiles!![newY* mapWidth +newX]) {
        if(vladMap!![newY* mapWidth +newX] > iteration + 1) {
            vladMap!![newY* mapWidth +newX] = iteration + 1
            val CheckMoveTmp = checkMoveLow(newX, newY, iteration + 1)
            if (CheckMoveTmp.iteration_hit < bestCheckMove.iteration_hit && CheckMoveTmp.direction != Direction.NONE) {
                bestCheckMove = CheckMoveTmp
                bestCheckMoveDirection = Direction.UP
            }
        }
    }


    //check down
    if(Y == mapHeight) {
        newY = 0
    } else {
        newY = Y + 1
    }
    newX = X

    if (!wallTiles!![newY* mapWidth +newX]) {
        if(vladMap!![newY* mapWidth +newX] > iteration + 1) {
            vladMap!![newY* mapWidth +newX] = iteration + 1
            val CheckMoveTmp = checkMoveLow(newX, newY, iteration + 1)
            if (CheckMoveTmp.iteration_hit < bestCheckMove.iteration_hit && CheckMoveTmp.direction != Direction.NONE) {
                bestCheckMove = CheckMoveTmp
                bestCheckMoveDirection = Direction.DOWN
            }
        }
    }
    return checkMoveReturn(bestCheckMoveDirection, iteration, bestCheckMove.iteration_hit)
}

fun checkMove(X:Int, Y:Int, iteration:Int) : checkMoveReturn {

    var newX = 0
    var newY = 0

    // CHECK FOR o
    //-----------------------

    //check left
    if(X == 0) {
        newX = mapWidth
    } else {
        newX = X -1
    }
    newY = Y

    if (superPelletTiles!![newY* mapWidth +newX]) {
        return checkMoveReturn(Direction.LEFT, iteration, iteration)
    }

    //check right
    if(X == mapWidth) {
        newX = 0
    } else {
        newX = X + 1
    }
    newY = Y

    if (superPelletTiles!![newY* mapWidth +newX]) {
        return checkMoveReturn(Direction.RIGHT, iteration, iteration)
    }

    //check up
    if(Y == 0) {
        newY = mapHeight
    } else {
        newY = Y - 1
    }
    newX = X

    if (superPelletTiles!![newY* mapWidth +newX]) {
        return checkMoveReturn(Direction.UP, iteration, iteration)
    }

    //check down
    if(Y == mapHeight) {
        newY = 0
    } else {
        newY = Y + 1
    }
    newX = X

    if (superPelletTiles!![newY* mapWidth +newX]) {
        return checkMoveReturn(Direction.DOWN, iteration, iteration)
    }

    var bestCheckMove : checkMoveReturn = checkMoveReturn(Direction.NONE, 255, 255)
    var bestCheckMoveDirection : Direction = Direction.NONE

    // CHECK FOR _
    //-----------------------

    //check left
    if(X == 0) {
        newX = mapWidth
    } else {
        newX = X -1
    }
    newY = Y

    if (!wallTiles!![newY* mapWidth +newX]) {
        if(vladMap!![newY* mapWidth +newX] > iteration + 1) {
            vladMap!![newY * mapWidth + newX] = iteration + 1
            val CheckMoveTmp = checkMove(newX, newY, iteration + 1)
            if (CheckMoveTmp.iteration_hit < bestCheckMove.iteration_hit && CheckMoveTmp.direction != Direction.NONE) {
                bestCheckMove = CheckMoveTmp
                bestCheckMoveDirection = Direction.LEFT
            }
        }
    }


    //check right
    if(X == mapWidth) {
        newX = 0
    } else {
        newX = X + 1
    }
    newY = Y

    if (!wallTiles!![newY* mapWidth +newX]) {
        if(vladMap!![newY* mapWidth +newX] > iteration + 1) {
            vladMap!![newY* mapWidth +newX] = iteration + 1
            val CheckMoveTmp = checkMove(newX, newY, iteration + 1)
            if (CheckMoveTmp.iteration_hit < bestCheckMove.iteration_hit && CheckMoveTmp.direction != Direction.NONE) {
                bestCheckMove = CheckMoveTmp
                bestCheckMoveDirection = Direction.RIGHT
            }
        }
    }


    //check up
    if(Y == 0) {
        newY = mapHeight
    } else {
        newY = Y - 1
    }
    newX = X

    if (!wallTiles!![newY* mapWidth +newX]) {
        if(vladMap!![newY* mapWidth +newX] > iteration + 1) {
            vladMap!![newY* mapWidth +newX] = iteration + 1
            val CheckMoveTmp = checkMove(newX, newY, iteration + 1)
            if (CheckMoveTmp.iteration_hit < bestCheckMove.iteration_hit && CheckMoveTmp.direction != Direction.NONE) {
                bestCheckMove = CheckMoveTmp
                bestCheckMoveDirection = Direction.UP
            }
        }
    }


    //check down
    if(Y == mapHeight) {
        newY = 0
    } else {
        newY = Y + 1
    }
    newX = X

    if (!wallTiles!![newY* mapWidth +newX]) {
        if(vladMap!![newY* mapWidth +newX] > iteration + 1) {
            vladMap!![newY* mapWidth +newX] = iteration + 1
            val CheckMoveTmp = checkMove(newX, newY, iteration + 1)
            if (CheckMoveTmp.iteration_hit < bestCheckMove.iteration_hit && CheckMoveTmp.direction != Direction.NONE) {
                bestCheckMove = CheckMoveTmp
                bestCheckMoveDirection = Direction.DOWN
            }
        }
    }

    return checkMoveReturn(bestCheckMoveDirection, iteration, bestCheckMove.iteration_hit)
}

internal class MultithreadingDemo : Thread() {
    override fun run() {

        try {

            val input = skt.getInputStream()
            val reader = BufferedReader(InputStreamReader(input))
            val ow = skt.getOutputStream()
            val JSON = jacksonObjectMapper()
            JSON.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

            var inputData : gameDataClass = gameDataClass(gamestateClass(mapClass(emptyList(), 0,0,0), emptyList(), playerClass(0, false, 0, 0, 0)), "welcome")

            val cores = Runtime.getRuntime().availableProcessors()
            val threads = Array<MultithreadingBurner>(cores, { i-> MultithreadingBurner() })

            for(i in 0..cores-1) {
                threads[i].start()
            }

            while(true) {

                var done :Boolean = false
                val jsonString = reader.readLine()

                for(i in 0..cores-1) {
                    threads[i].suspend()
                }

                val tmpInputData : gameDataClass = JSON.readValue<gameDataClass>(jsonString)
                when (tmpInputData.messagetype) {
                    "welcome" -> {
                        val tmpInputData : startDataClass = JSON.readValue<startDataClass>(jsonString)
                        inputData.gamestate!!.map = tmpInputData.map
                        inputData.gamestate!!.you = tmpInputData.you
                    }
                    "startofround" -> {}
                    "stateupdate" -> inputData = tmpInputData
                    "dead" -> {
                        println("DEAD")
                        done = true
                    }
                    "endofround" -> {
                        println("ENDOFROUND")
                        done = true
                    }
                }

                if(done) {
                    continue
                }

                // fill arrays
                //--------------------
                mapHeight = inputData.gamestate!!.map.height
                mapWidth = inputData.gamestate!!.map.width
                mapSize = mapHeight * mapWidth

                wallTiles = Array<Boolean>(mapSize, { i -> false} )
                doorTiles = Array<Boolean>(mapSize, { i -> false} )
                pelletTiles = Array<Boolean>(mapSize, { i -> false} )
                superPelletTiles = Array<Boolean>(mapSize, { i -> false} )

                vladMap = Array<Int>(mapSize, { i -> Int.MAX_VALUE})

                val sizeY = inputData.gamestate!!.map.content.size
                val sizeX = inputData.gamestate!!.map.content[0].length

                var pos : Int = 0
                for(contentRow in inputData.gamestate!!.map.content) {
                    for (char in contentRow) {
                        when(char) {
                            '|' -> {
                                wallTiles!![pos] = true
                            }
                            '-' -> {
                                doorTiles!![pos] = true
                            }
                            '.' -> {
                                pelletTiles!![pos] = true
                            }
                            'o' -> {
                                superPelletTiles!![pos] = true
                            }
                        }
                        pos++
                    }
                }

                if(inputData.gamestate!!.you.isdangerous) {
                    for (player in inputData.gamestate!!.others) {
                        if (player.isdangerous) {
                            wallTiles!![player.y * mapWidth + player.x] = true
                        }
                    }
                } else {
                    for (player in inputData.gamestate!!.others) {
                        wallTiles!![player.y * mapWidth + player.x] = true
                        var newX = player.x
                        var newY = player.y
                        if (player.isdangerous) {
                            //check left
                            //-----------
                            if (player.x == 0) {
                                newX = mapWidth
                            } else {
                                newX = player.x - 1
                            }
                            newY = player.y
                            wallTiles!![newY * mapWidth + newX] = true
                            //check right
                            //------------
                            if (player.x == mapWidth) {
                                newX = 0
                            } else {
                                newX = player.x + 1
                            }
                            newY = player.y
                            wallTiles!![newY * mapWidth + newX] = true
                            //check down
                            //----------
                            if (player.y == mapHeight) {
                                newY = 0
                            } else {
                                newY = player.y + 1
                            }
                            newX = player.x
                            wallTiles!![newY * mapWidth + newX] = true
                            //check up
                            //---------
                            if (player.y == 0) {
                                newY = mapHeight
                            } else {
                                newY = player.y - 1
                            }
                            newX = player.x
                            wallTiles!![newY * mapWidth + newX] = true
                        }
                    }
                }

                var direction = checkMove(inputData.gamestate!!.you.x, inputData.gamestate!!.you.y, 0)

                if(direction.direction == Direction.NONE) {
                    vladMap = Array<Int>(mapSize, { i -> Int.MAX_VALUE})
                    direction = checkMoveLow(inputData.gamestate!!.you.x, inputData.gamestate!!.you.y, 0)
                }

                when (direction.direction) {
                    Direction.UP -> {
                        ow.write(("up\n").toByteArray())
                    }
                    Direction.DOWN -> {
                        ow.write(("down\n").toByteArray())
                    }
                    Direction.LEFT -> {
                        ow.write(("left\n").toByteArray())
                    }
                    Direction.RIGHT -> {
                        ow.write(("right\n").toByteArray())
                    }
                }

                for(i in 0..cores-1) {
                    threads[i].resume()
                }

            }
        } catch (e: Exception) {
            print(e.message)
        }
    }

    internal class MultithreadingBurner : Thread() {
        override fun run() {
            var wayne :Int = 0
            while (true) {
                wayne++
            }
        }
    }

}


fun main(args : Array<String>) {

    val botName = "NiosHD"

    try {
        val ow = skt.getOutputStream()
        ow.write(("NAME " + botName + "\n").toByteArray())

        val obj = MultithreadingDemo()
        obj.start()


        Thread.sleep(100)

    } catch (e: Exception) {
        print("Whoops! It didn't work!\n")
    }
}


