/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public abstract class InjectableValues {
    public abstract Object findInjectableValue(Object var1, DeserializationContext var2, BeanProperty var3, Object var4);

    public static class Std
    extends InjectableValues
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final Map<String, Object> _values;

        public Std() {
            this(new HashMap<String, Object>());
        }

        public Std(Map<String, Object> values2) {
            this._values = values2;
        }

        public Std addValue(String key, Object value) {
            this._values.put(key, value);
            return this;
        }

        public Std addValue(Class<?> classKey, Object value) {
            this._values.put(classKey.getName(), value);
            return this;
        }

        @Override
        public Object findInjectableValue(Object valueId, DeserializationContext ctxt, BeanProperty forProperty, Object beanInstance) {
            if (!(valueId instanceof String)) {
                String type2 = valueId == null ? "[null]" : valueId.getClass().getName();
                throw new IllegalArgumentException("Unrecognized inject value id type (" + type2 + "), expecting String");
            }
            String key = (String)valueId;
            Object ob = this._values.get(key);
            if (ob == null && !this._values.containsKey(key)) {
                throw new IllegalArgumentException("No injectable id with value '" + key + "' found (for property '" + forProperty.getName() + "')");
            }
            return ob;
        }
    }
}

