/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class AI {
    private final Socket socket = new Socket();
    private final JSONParser parser = new JSONParser();
    private PrintWriter out;
    private BufferedReader in;
    private int width;
    private int height;
    private int totalPellets;
    private int pelletsLeft;
    private char[][] board;
    private Player player;
    private Player[] opponents;

    public AI(String name) {
        try {
            String s;
            this.socket.connect(new InetSocketAddress("127.0.0.1", 54321));
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.out = new PrintWriter(this.socket.getOutputStream(), true);
            this.out.println("NAME " + name);
            while ((s = this.in.readLine()) != null) {
                JSONObject content;
                JSONObject msg = (JSONObject)this.parser.parse(s);
                String type = (String)msg.get("messagetype");
                if (type.equals("welcome")) {
                    content = (JSONObject)msg.get("map");
                    this.width = Math.toIntExact((Long)content.get("width"));
                    this.height = Math.toIntExact((Long)content.get("height"));
                    this.pelletsLeft = this.totalPellets = Math.toIntExact((Long)content.get("pelletsleft"));
                    this.board = new char[this.width][this.height];
                    this.player = new Player();
                    this.updatePlayer((JSONObject)msg.get("you"), this.player);
                    this.updateMap((JSONArray)content.get("content"));
                    continue;
                }
                if (!type.equals("stateupdate")) continue;
                content = (JSONObject)msg.get("gamestate");
                JSONObject jsonMap = (JSONObject)content.get("map");
                this.updatePlayer((JSONObject)content.get("you"), this.player);
                this.updateOpponents((JSONArray)content.get("others"));
                this.updateMap((JSONArray)jsonMap.get("content"));
                this.pelletsLeft = Math.toIntExact((Long)jsonMap.get("pelletsleft"));
                Move nextMove = this.findNextBestMove();
                if (nextMove == null) continue;
                this.out.println((Object)nextMove);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Move findNextBestMove() {
        Move nextMove = null;
        boolean[][] visited = new boolean[this.width][this.height];
        ArrayList<Node> bfsQue = this.neighbours(this.player.x, this.player.y, visited, null);
        ArrayList<Player[]> solutions = new ArrayList<Player[]>();
        boolean[] illegal = new boolean[4];
        while (!bfsQue.isEmpty()) {
            Player[] node = bfsQue.remove(0);
            visited[node.x][node.y] = true;
            if (this.board[node.x][node.y] == '.' || this.board[node.x][node.y] == 'o') {
                solutions.add(node);
            }
            bfsQue.addAll(this.neighbours(node.x, node.y, visited, (Node)node));
        }
        if (!this.player.isDangerous) {
            for (Player opponent : this.opponents) {
                if (!this.isDangerous(opponent.x, opponent.y)) continue;
                if (this.player.x < opponent.x) {
                    if (opponent.x - this.player.x < 3 && Math.abs(opponent.y - this.player.y) < 2) {
                        illegal[1] = true;
                    }
                } else if (this.player.x - opponent.x < 3 && Math.abs(opponent.y - this.player.y) < 2) {
                    illegal[0] = true;
                }
                if (this.player.y < opponent.y) {
                    if (opponent.y - this.player.y >= 3 || Math.abs(opponent.x - this.player.x) >= 2) continue;
                    illegal[3] = true;
                    continue;
                }
                if (this.player.y - opponent.y >= 3 || Math.abs(opponent.x - this.player.x) >= 2) continue;
                illegal[2] = true;
            }
        }
        Node best = null;
        double average = 0.0;
        for (Node node : solutions) {
            int pellets = 1;
            int count = 3;
            Node parent = node;
            while (parent.parent != null) {
                parent = parent.parent;
                if (this.board[parent.x][parent.y] == '.' || this.board[parent.x][parent.y] == 'o') {
                    ++pellets;
                }
                ++count;
            }
            if (parent.direction == Move.LEFT && illegal[0] || parent.direction == Move.RIGHT && illegal[1] || parent.direction == Move.UP && illegal[2] || parent.direction == Move.DOWN && illegal[3]) break;
            if (!((double)pellets / (double)count > average)) continue;
            average = (double)pellets / (double)count;
            best = parent;
        }
        System.out.println();
        if (best == null) {
            for (int i = 0; i < illegal.length; ++i) {
                if (!illegal[0] && this.player.x > 0 && this.board[this.player.x - 1][this.player.y] != '|') {
                    return Move.LEFT;
                }
                if (!illegal[1] && this.player.x < this.width - 1 && this.board[this.player.x + 1][this.player.y] != '|') {
                    return Move.RIGHT;
                }
                if (!illegal[2] && this.player.y > 0 && this.board[this.player.x][this.player.y - 1] != '|') {
                    return Move.UP;
                }
                if (illegal[3] || this.player.x >= this.height - 1 || this.board[this.player.x - 1][this.player.y + 1] == '|') continue;
                return Move.DOWN;
            }
            return null;
        }
        nextMove = best.direction;
        return nextMove;
    }

    private int distance(int x, int y, Player player) {
        return Math.abs(x - player.x) + Math.abs(y - player.y);
    }

    private boolean containsOpponent(int x, int y) {
        for (int i = 0; i < this.opponents.length; ++i) {
            if (this.opponents[i].x != x || this.opponents[i].y != y) continue;
            return true;
        }
        return false;
    }

    private boolean isDangerous(int x, int y) {
        for (int i = 0; i < this.opponents.length; ++i) {
            if (this.opponents[i].x != x || this.opponents[i].y != y) continue;
            return this.opponents[i].isDangerous;
        }
        return false;
    }

    private ArrayList<Node> neighbours(int x, int y, boolean[][] visited, Node parent) {
        Node node;
        ArrayList<Node> neighbours = new ArrayList<Node>();
        if (x > 0 && this.board[x - 1][y] != '|' && !visited[x - 1][y]) {
            node = new Node(x - 1, y);
            node.direction = Move.LEFT;
            node.parent = parent;
            neighbours.add(node);
        }
        if (x < this.width - 1 && this.board[x + 1][y] != '|' && !visited[x + 1][y]) {
            node = new Node(x + 1, y);
            node.direction = Move.RIGHT;
            node.parent = parent;
            neighbours.add(node);
        }
        if (y > 0 && this.board[x][y - 1] != '|' && !visited[x][y - 1]) {
            node = new Node(x, y - 1);
            node.direction = Move.UP;
            node.parent = parent;
            neighbours.add(node);
        }
        if (y < this.height - 1 && this.board[x][y + 1] != '|' && !visited[x][y + 1]) {
            node = new Node(x, y + 1);
            node.direction = Move.DOWN;
            node.parent = parent;
            neighbours.add(node);
        }
        return neighbours;
    }

    private void updateMap(JSONArray jsonMap) {
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                this.board[j][i] = ((String)jsonMap.get(i)).charAt(j);
            }
        }
    }

    private void updatePlayer(JSONObject jsonPlayer, Player player) {
        player.id = Math.toIntExact((Long)jsonPlayer.get("id"));
        player.x = Math.toIntExact((Long)jsonPlayer.get("x"));
        player.y = Math.toIntExact((Long)jsonPlayer.get("y"));
        player.score = Math.toIntExact((Long)jsonPlayer.get("score"));
        player.isDangerous = (Boolean)jsonPlayer.get("isdangerous");
    }

    private void updateOpponents(JSONArray jsonOpponents) {
        this.opponents = new Player[jsonOpponents.size()];
        for (int i = 0; i < this.opponents.length; ++i) {
            Player opponent = new Player();
            this.updatePlayer((JSONObject)jsonOpponents.get(i), opponent);
            this.opponents[i] = opponent;
        }
    }

    private void printBoard() {
        for (int i = 0; i < this.height; ++i) {
            String line = "";
            for (int j = 0; j < this.width; ++j) {
                line = line + this.board[j][i];
            }
            System.out.println(line);
        }
        System.out.println("You: " + this.player);
    }

    public static void main(String[] args) {
        AI ai1 = new AI("CruiseControl");
    }

    private class Node {
        public int x;
        public int y;
        public Move direction;
        public Node parent;
        public Player player;

        public Node(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public String toString() {
            return "x:" + this.x + ", y: " + this.y;
        }
    }

    private class Player {
        int id;
        int x;
        int y;
        int score;
        boolean isDangerous;

        private Player() {
        }

        public String toString() {
            return "x:" + this.x + ", y:" + this.y + ", score:" + this.score;
        }
    }

    private static enum Move {
        LEFT,
        RIGHT,
        UP,
        DOWN;

    }
}

