#pragma once

// Std. Includes
#include <vector>

// GL Includes
#include <GL/glew.h>
#include <glm/glm.hpp>
#include <glm/gtc/matrix_transform.hpp>

// Image loader
#include <SOIL/SOIL.h>

class Texture {
    public:
        GLuint texture;
        Texture(const GLchar *path) {
            int width, height;
            unsigned char *image = SOIL_load_image(path, &width, &height, 0, SOIL_LOAD_RGB);

            glGenTextures(1, &texture);
            glBindTexture(GL_TEXTURE_2D, texture);

            glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_MIRRORED_REPEAT);
            glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_MIRRORED_REPEAT);

            glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
            glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

            glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, width, height, 0, GL_RGB, GL_UNSIGNED_BYTE, image);
            glGenerateMipmap(GL_TEXTURE_2D);
            
            SOIL_free_image_data(image);
            glBindTexture(GL_TEXTURE_2D, 0);
        }

        void bind() {
            glBindTexture(GL_TEXTURE_2D, this->texture);
        }

        void unbind() {
            glBindTexture(GL_TEXTURE_2D, 0);
        }
};
