#version 330 core
out vec4 FragColor;

in VS_OUT {
    vec3 FragPos;
    vec3 Normal;
    vec2 TexCoords;
} fsIn;

uniform sampler2D uiTexture;
uniform float alpha = 1.0f;
uniform vec3 setColor = vec3(1,1,1);

void main()
{
	vec2 tc = fsIn.TexCoords;
	tc.y *= -1.0f;
    vec4 color = texture(uiTexture, tc);
	color.a *= alpha;
    FragColor = color * vec4(setColor,1);

	//float gamma = 2.2;
    //FragColor.rgb = pow(FragColor.rgb, vec3(1.0/gamma));
}