#version 330 core
layout (location = 0) in vec3 position;
layout (location = 1) in vec3 normal;
layout (location = 2) in vec2 texCoords;

out VS_OUT {
    vec3 FragPos;
    flat vec3 Normal;
    vec2 TexCoords;
	float Pulse;
} vsOut;

uniform mat4 projection;
uniform mat4 view;
uniform mat4 model;
uniform vec3 sizePos;

void main()
{
	vec3 distance = sizePos - position;
	vec3 p = position;
	vsOut.Pulse = 0.0;
	if(length(distance) < 2.0)
	{
		float size = 1-length(distance)/2;
		p = p + size*normal;
		vsOut.Pulse = size;
	}
    gl_Position = projection * view * model * vec4(p, 1.0f);
    vsOut.FragPos = position;
    vsOut.Normal = mat3(view) * normal;
    vsOut.TexCoords = texCoords;
}