#version 330 core
out vec4 FragColor;

in VS_OUT {
    vec3 FragPos;
    vec3 Normal;
    vec2 TexCoords;
	vec3 ModelPos;
} fsIn;

uniform vec3 lightPos;
uniform vec3 viewPos;
uniform vec3 flashColor;
uniform sampler2D floorMap;
uniform sampler2D spillMap;
uniform sampler2D greetMap;
uniform float threshold = 1.0;
uniform float shockwave = 0.0;


void main()
{
	vec4 colorFloor = texture(floorMap, fsIn.TexCoords);
	vec4 colorSpill = texture(spillMap, fsIn.TexCoords);
	vec4 colorGreet = texture(greetMap, fsIn.TexCoords);
	
	vec4 spillColorThreshold;

	if(colorSpill.r > threshold)
		spillColorThreshold = vec4(1,1,1,1);
	else
		spillColorThreshold = vec4(0,0,0,1);
	spillColorThreshold *= vec4(0.1,0.1,0.2,1.0);
    vec3 color = colorFloor.xyz + flashColor;

	vec3 len = (fsIn.ModelPos - vec3(0,0,0));

	vec4 AddCol = vec4(0);
	if(length(len) > shockwave && length(len) < shockwave + 0.02)
		AddCol = vec4(0.2, 0.2, 0.4,1)/(length(len)*20.0);
    FragColor = colorFloor+spillColorThreshold - colorGreet*spillColorThreshold + AddCol;
	//FragColor = spillColorThreshold;
	//float gamma = 2.2;
    //FragColor.rgb = pow(FragColor.rgb, vec3(1.0/gamma));
}