#version 330 core
layout (location = 0) in vec3 position;
layout (location = 1) in vec3 normal;
layout (location = 2) in vec2 texCoords;

out VS_OUT {
    vec3 FragPos;
    vec3 OriginalNormal;
    vec3 Normal;
    vec2 TexCoords;
} vsOut;

uniform mat4 projection;
uniform mat4 view;
uniform mat4 model;
uniform float time;
uniform float noiseScale = 0;

float mod289(float x){return x - floor(x * (1.0 / 289.0)) * 289.0;}
vec4 mod289(vec4 x){return x - floor(x * (1.0 / 289.0)) * 289.0;}
vec4 perm(vec4 x){return mod289(((x * 34.0) + 1.0) * x);}

float noise(vec3 p){
    vec3 a = floor(p);
    vec3 d = p - a;
    d = d * d * (3.0 - 2.0 * d);

    vec4 b = a.xxyy + vec4(0.0, 1.0, 0.0, 1.0);
    vec4 k1 = perm(b.xyxy);
    vec4 k2 = perm(k1.xyxy + b.zzww);

    vec4 c = k2 + a.zzzz;
    vec4 k3 = perm(c);
    vec4 k4 = perm(c + 1.0);

    vec4 o1 = fract(k3 * (1.0 / 41.0));
    vec4 o2 = fract(k4 * (1.0 / 41.0));

    vec4 o3 = o2 * d.z + o1 * (1.0 - d.z);
    vec2 o4 = o3.yw * d.x + o3.xz * (1.0 - d.x);

    return o4.y * d.y + o4.x * (1.0 - d.y);
}

void main()
{
	float t = time / 2.0f;
	vec3 pos = position;
	float n = noise(pos * 1.5f + t);

	float E = 0.001;
	vec3 p = position;
	vec3 p1 = position;
	p1.x += E;
	float nX = (noise(p1 * 1.5f + t));
	vec3 p2 = position;
	p2.y += E;
	float nY = (noise(p2 * 1.5f+ t));
	vec3 p3 = position;
	p3.z += E;
	float nZ = (noise(p3 * 1.5f+ t));

	vec3 bumpNew = vec3((nX-p.x)/E,(nY-p.y)/E,(nZ-p.z)/E);
	vec3 nB = normal - bumpNew;

    gl_Position = projection * view * model * vec4(pos + noiseScale * pos * n, 1.0f);
    vsOut.FragPos = pos + pos * n;
    vsOut.Normal = (mat3(view * model)) * nB;
    vsOut.TexCoords = texCoords;
	vsOut.OriginalNormal = normal;
}