#version 330 core
layout (location = 0) in vec3 position;
layout (location = 1) in vec3 normal;
layout (location = 2) in vec2 texCoords;

out VS_OUT {
    vec3 FragPos;
    vec3 Normal;
    vec2 TexCoords;
} vsOut;

uniform mat4 projection;
uniform mat4 view;
uniform mat4 model;
uniform float time;

void main()
{
	vec3 p = position;
	p.z += 0.01 * sin(time + p.x * 20.0f + p.y * 10.0f);

    gl_Position = projection * view * model * vec4(p, 1.0f);
    vsOut.FragPos = position;
    vsOut.Normal = (mat3(view * model)) * normal;
	vec2 tc = texCoords;
	tc.x = tc.x * 0.5;
	tc.x += time * 0.1;
    vsOut.TexCoords = tc;
}