#version 330 core
out vec4 FragColor;

in VS_OUT {
    vec3 FragPos;
    vec3 Normal;
    vec2 TexCoords;
} fsIn;

uniform sampler2D ringDiffuseMap;
uniform sampler2D rinNormalMap;
uniform vec3 specColor = vec3(1.0, 1.0, 1.0);

uniform vec3 lightPos;
uniform vec3 viewPos;

void main()
{           
    vec3 color = texture(ringDiffuseMap, fsIn.TexCoords).rgb;

    vec3 ambient = 0.00 * color;

    vec3 lightDir = normalize(lightPos - fsIn.FragPos);
    vec3 normal = normalize(fsIn.Normal);
    float diff = max(dot(lightDir, normal), 0.0);
    vec3 diffuse = diff * color;

    vec3 viewDir = normalize(viewPos - fsIn.FragPos);
    
    float spec = 0.0;
    vec3 halfwayDir = normalize(lightDir + viewDir);  
    spec = pow(max(dot(normal, halfwayDir), 0.0), 32.0);
    
    vec3 specular = vec3(0.3) * spec;
    FragColor = vec4(ambient + diffuse + specular * specColor, 1.0f);

	//float gamma = 2.2;
    //FragColor.rgb = pow(FragColor.rgb, vec3(1.0/gamma));
}