#version 330 core
out vec4 FragColor;

in vec2 TexCoords;

uniform float amount = 0.7;
uniform float size = 0.1;
uniform sampler2D screenTexture;

void main()
{
	float dist = distance(TexCoords, vec2(0.5,0.5)) * 0.7;
	vec4 baseColor = texture(screenTexture, TexCoords);
	baseColor.rgb *= smoothstep(amount, size, dist);
	FragColor = baseColor;
    //color = texture(screenTexture, TexCoords);
}