#version 330 core
out vec4 FragColor;

in vec2 TexCoords;

uniform sampler2D colorImage;
uniform sampler2D depthImage;
uniform sampler2D blurImage;

uniform float Distance = 50;
uniform float Range = 60;
uniform float Near = 10;
uniform float Far = 150;

void main()
{
    vec3 color = texture(colorImage, TexCoords).rgb;
    vec3 depth = texture(depthImage, TexCoords).rgb;
    vec3 blur = texture(blurImage, TexCoords).rgb;
    //depth.r = 1 - depth.r;
	//float farClip = Far / ( Far - Near );
	//float fSceneZ = ( -Near * farClip ) / ( depth.r - farClip);
	//float blurFactor = clamp(abs(fSceneZ-Distance)/Range,0,1);
    
	float blurFactor = smoothstep(0, Range, abs(Distance - (depth.r * Far)));

	
	FragColor = vec4(mix(color, blur, blurFactor), 1.0);
	//FragColor = vec4(blurFactor,blurFactor,blurFactor, 1.0);
	//FragColor = vec4(depth, 1.0);
}