#version 330 core
out vec4 FragColor;

in vec2 TexCoords;

uniform sampler2D screenTexture;
uniform sampler2D depthNearTexture;
uniform sampler2D depthFarTexture;
uniform float pwr = 75.0;
uniform float fadeToWhite;

void main()
{
	vec4 dN = texture(depthNearTexture, TexCoords);
	vec4 dF = texture(depthFarTexture, TexCoords);
	vec4 cM = texture(screenTexture, TexCoords);

	float thickness = abs(dN.r - dF.r);
	float intensity = exp(-pwr * thickness);

	if(dN.r >= 0.5f)
		FragColor = (intensity * cM);
	else FragColor = cM;
	FragColor = mix(FragColor, vec4(1,1,1,1), fadeToWhite);

	//FragColor = cM; // pass-through
}