var Mun = function(){
    PartBase.call(this);

    //POSTPROCESSING
    this.setHorizontalBlur(4);
    this.setVerticalBlur(8);
    this.setBloom(6);
    this.setDoF({
        focus : 1.0,
        maxblur: 2.0,
        aperture: 0.01
    });

    this.texture = TDEMO.TEXTURES.getTextures().katto
    this.pallo = this.createBall();
    this.scene.add(this.pallo);

    this.pointLight = new THREE.PointLight( 0xffffff, 2, 800 );
    this.pallo.add(this.pointLight);


};

Mun.prototype = PartBase.prototype.inheritance();

Mun.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta, true);

    var ballp = TDEMO.SYNC.getObjPosition();
    this.pallo.position.x = ballp.x;
    this.pallo.position.y = ballp.y;
    this.pallo.position.z = ballp.z;

    var ballr = TDEMO.SYNC.getObjRotation();
    this.pallo.rotation.x = ballr.x;
    this.pallo.rotation.y = ballr.y;
    this.pallo.rotation.z = ballr.z;

    this.texture.offset.x += delta*0.005;
    this.texture.needsUpdate = true;

};


Mun.prototype.createBall = function(){
    var geometry = new THREE.SphereGeometry(200, 128, 128);
    var material = new THREE.MeshBasicMaterial({
        color : 0xF07030,
        map : this.texture
    });

    var pallo = new THREE.Mesh(geometry, material);
    return pallo;
}
