#version 150
attribute vec3 pos;
attribute vec2 tc; 
attribute vec3 normal; 

varying vec3 n; 
varying vec2 tex;
varying vec3 vn;
varying vec3 opos; 
varying vec3 ipos; 
uniform mat4 viewproj; 
uniform mat4 view;
uniform mat3 nview;
uniform float time; 

void main()
{	
	tex = tc*1.0;
	vec3 adjPos = pos.xyz;
	gl_Position = viewproj*vec4(adjPos, 1.0);
    gl_Position.z -= 1.0e-3;
	n = normalize(normal);
	vn = normalize(nview*n);

	opos = (view*vec4(adjPos.xyz, 1.0)).xyz;
	ipos = adjPos.xyz;
}	

//FRAGMENT
//#version 150
uniform sampler2D Texture0; 
uniform sampler2D Texture1; 
uniform float time; 
uniform mat3 nview;
uniform mat4 tview;
uniform vec3 eyePos;
uniform vec3 lightPos;
float rand(vec2 co)
{
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

vec4 baseColor = vec4(.05, .175, .3, 1.0);      // dark-ish blue
vec4 mainLight= vec4(.4, .75, .9, 1.0);         // very light blue
vec4 orangeLight= vec4(.93, .65, .5, 1.0);       // orange! 
vec4 sideLight= vec4(.75, .55, .65, 1.0);


void main()
{  
	gl_FragColor = vec4(.220);
	gl_FragColor = mix(gl_FragColor, vec4(.82), min(1.0, -ipos.z/600));

	gl_FragColor.rgb = n;
	gl_FragColor = vec4(tex, 0, 0);
	gl_FragColor = vec4(normalize(.5+.5*n), 0);
	//gl_FragColor = vec4(.5+.5*normalize((fNormal)), 0);
	//gl_FragColor = vec4(gl_Position);1

	// Distance fog

	//vec3 lightPos = vec3(-10.0, 200 ,2000);
	float fog = min(1.0, pow(length(ipos-eyePos)/1500.0, .1275));
	
	float diffuse = .25+.75*pow(max(0.0, dot(normalize(ipos-lightPos), n)), .45);
	gl_FragColor = vec4(diffuse);

  	vec4 ambient  = .5*mix(vec4(0), orangeLight, pow(n.x*.5+.5, 1.3));
    ambient  += .5*mix(vec4(0), baseColor, pow(n.z*.5+.5, 1.3));
    ambient  += .5*mix(vec4(0), sideLight, pow(n.y*.5+.5, 1.3));

    vec3 viewDir = normalize(opos);
    vec3 reflectDir = reflect(vn, normalize(eyePos-ipos));
    float specular = max(0.0, dot(-reflectDir, -normalize(lightPos-ipos)));


    
    gl_FragColor = vec4(.2*specular+.2*diffuse)+ambient;


    vec4 color = diffuse*4.0*ambient + ambient*2.0*pow(specular, 2.0);
    color += ambient*.3*pow(specular, 18.0);
    color += .3*ambient;

    gl_FragColor = color;
    
    gl_FragColor = 1.5*vec4(specular);
    gl_FragColor = 3.0*ambient*vec4(diffuse);
    gl_FragColor += 1.75*vec4(pow(1.005*specular, 18.0));

    gl_FragColor += 1.5*vec4(specular);
    gl_FragColor += 1.75*vec4(pow(1.005*specular, 48.0));
    gl_FragColor += ambient*.833*vec4(specular);
    gl_FragColor += .4*ambient;
   
    //gl_FragColor *= vec4(1.0, 0, 0, 0)*ipos.y/200.0;
    //gl_FragColor = 1.75*vec4(pow(1.005*specular, 48.0));

    //gl_FragColor = mix((1.0-min(vec4(1.0), gl_FragColor), vec4(.92), fog);
     //gl_FragColor = (1.0-min(vec4(1.0), gl_FragColor))*.5;
     float preM = gl_FragColor.a;
     gl_FragColor = 10.122*(1.0-clamp( gl_FragColor,vec4(0.0), vec4(1.0)));
     gl_FragColor = mix(gl_FragColor, vec4(.92), fog);


     gl_FragColor.a = 0.0;
     //gl_FragColor.a = 1.0;
    // gl_FragColor.a = mix(preM, 0.0, fog);
   // gl_FragColor = vec4(,0,0,1);

    //gl_FragColor = vec4((vn+1.0)*.5f, 1.0);

   // gl_FragColor = vec4(viewDir, 1.0);
    //gl_FragColor = 1.0*ambient;
	//gl_FragColor = vec4(normalize(.5+.5*vn), 0);

	//if (tex.x>.7475 && tex.x<.7525 )
	//	gl_FragColor = vec4(1.0,ipos.y/120.0,0,0);

}
