#version 330 core

in vec2 texCoord;
in vec4 vertexFragColor;
out vec4 fragColor;
uniform sampler2D texture0;
uniform float time = 1.0;
uniform vec4 color = vec4(1,1,1,1);
uniform vec2 speed = vec2(1,1);
uniform vec2 magnitude = vec2(0.01,0.2);


float rand(vec2 coord)
{
    return fract(sin(dot(coord.st,vec2(12.9898,78.233)+time)) * 43758.5453);
}

void main()
{
    vec2 coord=texCoord;
    coord.s -= sin(rand(coord))*0.02;

    float delta = cos(coord.s*30 + -time*speed.y*10)*magnitude.y;
    delta += sin(coord.s*10 + -time*speed.y*4)*magnitude.y;
    coord.t -= delta * texCoord.s;
    fragColor = texture(texture0, coord) * color;
}
