#version 330 core

layout(location = 0) in vec3 vertexPosition;
layout(location = 1) in vec2 vertexTexCoord;
layout(location = 2) in vec3 vertexNormal;
layout(location = 3) in vec4 vertexColor;

out vec2 texCoord;
out vec4 vertexFragColor;
uniform mat4 mvp;
uniform float time = 0.0;

float rand(vec2 coord)
{
    return fract(sin(dot(coord.st,vec2(12.9898,78.233)+time)) * 43758.5453);
}

void main() {
    gl_Position =  mvp * vec4(vertexPosition+rand(vertexPosition.xy)*0.3, 1);
    texCoord = vertexTexCoord;
    vertexFragColor = vertexColor;
}
