#ifdef GL_ES
precision mediump float;
precision mediump int;
#endif

uniform sampler2D texture;
uniform vec2 texOffset;

varying vec4 vertColor;
varying vec4 vertTexCoord;

void main() {
	highp int vertTexCoordX = int(vertTexCoord.s/texOffset.s);
	highp int vertTexCoordY = int(vertTexCoord.t/texOffset.t); 
	float multiplier = 1.0f;
	if (vertTexCoordY%4==0) multiplier = 0.3f;
	if (vertTexCoordY%4==1) multiplier = 0.6f;
	if (vertTexCoordY%4==3) multiplier = 0.6f;
	vec4 col0 = texture2D(texture, vertTexCoord.st);
	vec4 mult = vec4(multiplier);
	col0 = mult * col0;
	gl_FragColor = col0 * vertColor;
}