#ifdef GL_ES
precision mediump float;
precision mediump int;
#endif

uniform sampler2D texture;
uniform int power;
varying vec4 vertTexCoord;


void main() {
  // normalize to the center
  vec2 p = vertTexCoord.st - 0.5;
  
  // cartesian to polar coordinates
  float r = length(p);
  float a = atan(p.y, p.x);
  
  // kaleidoscope
  //float sides = 6.; 
  float sides = power;	
  float tau = 2. * 3.1416;
  a = mod(a, tau/sides);
  a = abs(a - tau/sides/2.);
  
  // polar to cartesian coordinates
  p = r * vec2(cos(a), sin(a));
  
  // sample the webcam
  vec4 color = texture2D(texture, p + 0.5);
  gl_FragColor = color;
}