var TICK;

var fontName = "coolvetica rg.ttf";
var fontPrimaryColor = {"r":0x5f,"g":0xcb,"b":0xef};
var fontSecondaryColor = {"r":0x7f,"g":0x7f,"b":0x7f};

var sceners = [
	"Kuroto",
	"FRaNKy",
	"BeRo",
	"Lucid",
	"Admiral",
	"bodo",
	"jco",
	"Oni",
	"Chaotic",
	"fashion",
	"xxx",
	"raw style",
	"mouldyCat",
	"pumpuli",
	"cce",
	"Sanity",
	"Terwiz",
	"branch",
	"H7",
	"rimina",
	"teel",
	"waffle",
	"h0ffman",
	"BoyC",
	"gargaj",
	"Falken",
	"TheHat",
	"funkyJebronimo",
	"rensje",
	"Flashlight",
	"Max Blazer",
	"Knoeki",
	"peerke",
	"andro",
	"RoccoW",
	"Maikel",
	"wobble",
	"aquanaga",
	"Jobj",
	"PerfectPC",
	"tenfour",
	"DJefke",
	"psykon",
	"Luisa",
	"Virgill",
	"Ramses",
	"Skyrunner",
	"mAtt",
	"1x",
	"ronny",
	"chaos",
	"Response",
	"cupe",
	"p2",
	"britelite",
	"Chaj",
	"noby",
	"spiikki",
	"urs",
	"msqrt",
	"myy",
	"ricky martin",
	"Ixion",
	"Roeltje",
	"ToasTer86",
	"Gabbie",
	"Tropical Trevor",
	"Tibou",
	"Tseebleffunk",
	"RoenyRoeny",
	"Kii",
	"ferris",
	"nosfe"
];


function getRandomArrayIndex(array)
{
    if (array.length !== void null)
    {
        return Math.floor(Math.random() * array.length);
    }

    return undefined;
};

function randomPopAnswer(list) {
	var selectedAnswerIndex = getRandomArrayIndex(list);
	var answer = list[selectedAnswerIndex];
	list.splice(selectedAnswerIndex,1);

	return answer;
}

/*
Missions:
Saving people money so they can live better.

Exxon Mobil Corporation is committed to being the world's premier petroleum and petrochemical company. To that end, we must continuously achieve superior financial and operating results while simultaneously adhering to high ethical standards

Apple's current mission statement is, “Apple designs Macs, the best personal computers in the world, along with OS X, iLife, iWork and professional software. Apple leads the digital music revolution with its iPods and iTunes online store.Apple's current mission statement is, “Apple designs Macs, the best personal computers in the world, along with OS X, iLife, iWork and professional software. Apple leads the digital music revolution with its iPods and iTunes online store.

McKesson Mission Statement: "Our mission is to provide comprehensive pharmacy solutions that improve productivity, profitability and result in superior patient care and satisfaction."

Our mission is to help people live healthier lives and to help make the health system work better for everyone. ... We work with health care professionals and other key partners to expand access to quality health care so people get the care they need at an affordable price.

Millions of times a day, close to home and across the country, we’re helping people on their path to better health.

We’re reinventing pharmacy to have a more active, supportive role in each person’s unique health experience and in the greater health care environment—from advising on prescriptions to helping manage chronic and specialty conditions to providing quality walk-in medical care and pharmacy benefits management.

CVS Health is helping people on their path to better health.

Because we’re present in so many moments, in ways that are more affordable and effective, we’re able to positively influence health behavior and shape the future of health care for people, businesses and communities.

Health is everything.

History

Explore the key moments in our story as we trace back our roots.

CVS Health is reinventing pharmacy. Explore each of our offerings to find out how.

General Motors Mission Statement: 

"G.M. is a multinational corporation engaged in socially responsible operations, 

worldwide. It is dedicated to provide products and services of such quality that our 

customers will receive superior value while our employees and business partners will 

share in our success and our stock-holders will receive a sustained superior return on 

their investment."

Ford Motor Company mission statement 2013
“One Team.
People working together as a lean, global enterprise for automotive leadership, as measured by:
Customer, Employee, Dealer, Investor, Supplier, Union/Council, and Community Satisfaction
One Plan.

Aggressively restructure to operate profitably at the current demand and changing model mix;
Accelerate development of new products our customers want and value;
Finance our plan and improve our balance sheet;
Work together effectively as one team.
One Goal.
An exciting viable Ford delivering profitable growth for all.”

Our mission is to exploit technical innovations for the benefit of AT&T and its customers by implementing next-generation technologies and network advancements in AT&T's services and operations.

*/

/*

0:00 - 0:11 - 
0:11 - 0:22
     - 0:33
     - 0:44
     - 1:18
     - 1:40
     - 2:01
     - 2:13
     - 2:25 - 2:29 end screen (follow us in...)

+ moving sky + skyscraper
+ night road + car lights
+ product planning
+ final product
+ magic quadrant (greetings)
+ end screen

"connections": lines + dots connecting
charts: pie charts / bars
pictures in a shape of sphere
meeting room pictures (projector screen / computers with visuals)
phone conversation train ride pictures
jml-coin qr-codes

https://github.com/DDRBoxman/QR-Code-SVG-Logo-Generator

tekstejä:
- innovation. progress. motivation.
- quantity over quality over equality
- In today's fast-paced economy big players eat the little players
- J
- we make demoscene great again
- value for life
- demoscene for life
- annual general shareholders meeting
- Demoscene as a service


- magic quadrant: https://cdn2.hubspot.net/hub/117943/file-2104713361-png/gartner-magic-quadrant.png

- our missing

cost efficiency
agility
better innovations


we bring you 

advertisement board: http://www.istockphoto.com/fi/photo/the-advertisement-board-gm524027276-92125415
empty highway: http://www.istockphoto.com/fi/photo/aerial-shot-of-one-car-on-freeway-gm94502198-15201974
meeting room: http://www.istockphoto.com/fi/photo/architect-presenting-project-to-a-group-of-managers-gm614715418-106463941
meeting room empty: http://www.istockphoto.com/fi/photo/meeting-room-gm155678767-21693424
Group of young business professionals having a meeting: http://www.istockphoto.com/fi/photo/group-of-young-business-professionals-having-a-meeting-gm507958988-84975537
Business Group Meeting Discussion Strategy Working Concept: http://www.istockphoto.com/fi/photo/business-group-meeting-discussion-strategy-working-concept-gm511857150-86850993
Seated businesspeople discussing in meeting room: http://www.istockphoto.com/fi/photo/seated-businesspeople-discussing-in-meeting-room-gm132056565-6476620

#BetterThanSlush
www.jumalauta.org/17v
Twitter: https://twitter.com/JumalautaInc
YouTube: https://www.youtube.com/channel/UCjwiLEbHTFbnoYKh74klppg
Pouet: http://www.pouet.net/groups.php?which=325
Demozoo: https://demozoo.org/groups/1297/
Facebook: https://www.facebook.com/Jumalauta-443630416028756/

Compos:
Jumalauta Demo
The Compo
Committee Music
One Song Sample Music
VGA Graphics
Fast Graphics
Elevator Pitch Compo
Popup Compos
Secret Satan

*/

Demo.prototype.addLink = function(animation, image, url) {
	var imageAnimation = Utils.deepCopyJson(animation);
	var urlAnimation = Utils.deepCopyJson(animation);

	imageAnimation["image"] = image;
	imageAnimation["scale"] = [{"uniform2d":0.10}];
	imageAnimation["position"] = [{"x":50,"y":100}];

	urlAnimation["text"] = {"name":fontName,"string":url};
	urlAnimation["scale"] = [{"uniform2d":0.4}];
	urlAnimation["position"] = [{"x":urlAnimation.urlX,"y":100}];

	this.loader.addAnimation([imageAnimation]);
	this.loader.addAnimation([urlAnimation]);

}

Demo.prototype.preInitEndAnimation = function(layer, start, duration) {
	var textDuration = duration-4
	var textDurationFade = 1;

	this.loader.addAnimation([
	{
		 "start": start, "duration": textDuration
		,"image": "data/jml_end_title.png"
		,"color": [
			 {"a":0}
			,{"a":255, "duration":textDurationFade}
			,{"duration":textDuration-textDurationFade*2}
			,{"a":0, "duration":textDurationFade}

		]
		,"layer": layer
	}]);

	this.loader.addAnimation([
	{
		 "start": start+textDuration-textDurationFade, "duration": 1.5
		,"image": "data/jml_end_date.png"
		,"color": [
			 {"a":0}
			,{"a":255, "duration":textDurationFade}
			,{"duration":textDuration-textDurationFade*2}
			,{"a":0, "duration":textDurationFade}

		]
		,"layer": layer
	}]);
	this.loader.addAnimation([
	{
		 "start": start+textDuration-textDurationFade+1, "duration": textDuration-1
		,"image": ["data/jml_end_date2.png","data/betterthanslush.png"]
		,"color": [
			 {"a":0}
			,{"a":255, "duration":textDurationFade}
			,{"duration":textDuration-textDurationFade*2}
			,{"a":0, "duration":textDurationFade}

		]
		,"layer": layer+1
		,"shader":{"name":"data/shader/distortion.fs",
			"variable":[
				 {"name":"time","value":["{return getSceneTimeFromStart();}"]}
				,{"name":"timeMultiplier","value":[0.0003]}
				,{"name":"pixelSize","value":[0.01,0.01]}
				,{"name":"noiseWaveSpeed","value":[-3]}
				,{"name":"noiseWaveSize","value":[5]}
				,{"name":"noiseLuminance","value":[1]}
				,{"name":"texture2","type":"int","value":[1]}
				,{"name":"noiseAlpha","value":[0.2]}
				,{"name":"colorComponentDistortionX","value":[0.01,0.02,0.02,0.02]}
				,{"name":"colorComponentDistortionY","value":[0.01,0.02,0.02,0.02]}
			]
		}

	}]);


	var ads = [
		 {"image": "data/icon_www.png",      "url":"www.jumalauta.org/jml17v", "urlX":240}
		,{"image": "data/icon_twitter.png",  "url":"https://twitter.com/JumalautaInc", "urlX":280}
		,{"image": "data/icon_facebook.png", "url":"https://www.facebook.com/JumalautaOfficial/", "urlX":360}
		,{"image": "data/icon_youtube.png",  "url":"https://www.youtube.com/channel/UCjwiLEbHTFbnoYKh74klppg", "urlX":470}
		,{"image": "data/icon_pouet.png",    "url":"http://www.pouet.net/groups.php?which=325", "urlX":350}
	]

	var ad_i = 0;
	for(var i = 0; i < ads.length; i++) {
		var textDuration = 3.75;
		var textDurationFade = textDuration/4;
		this.addLink(
			{
				 "start": start+i*(textDuration-textDurationFade), "duration": textDuration
				,"layer": layer
				,"scale": [{"uniform2d":0.10}]
				,"position": [{"x":50,"y":100}]
				,"color": [
					   {"r":0,"g":0,"b":0,"a":0}
					  ,{"duration":textDurationFade,"a":255}
					  ,{"duration":textDuration-textDurationFade*2}
					  ,{"duration":textDurationFade,"a":0}
				]
				,"urlX":ads[i].urlX
			}
			,ads[i].image
			,ads[i].url
		);
	}
}

function drawObjectCube(animation)
{
	var position = animation.initialPosition;
	var size = Utils.deepCopyJson(animation.initialSize);

	var time = getSceneTimeFromStart();
    var brightColor = demoPlayer.calculateColorAnimation(time, animation, animation.color);
    var darkColor = brightColor;

	if (animation.shadowFakery === true) {
	    darkColor = Utils.deepCopyJson(brightColor);
	    var darkness = 0.4;
	    darkColor.r *= darkness;
	    darkColor.g *= darkness;
	    darkColor.b *= darkness;
	}

	var time = getSceneTimeFromStart();
	var fade = (time-animation.start)/0.75;
	if (fade > 1) { fade = 1; }

	size.y *= fade;

	glBegin(GL_QUADS);
	glColor4ub(darkColor.r, darkColor.g, darkColor.b, darkColor.a);
	//top
	glNormal3f( 0, 1, 0 );
	glTexCoord2d(1.0,1.0);
	glVertex3f( size.x+position.x, size.y+position.y, -size.z+position.z);
	glNormal3f( 0, 1, 0 );
	glTexCoord2d(0.0,1.0);
	glVertex3f(-size.x+position.x, size.y+position.y, -size.z+position.z);
	glNormal3f( 0, 1, 0 );
	glTexCoord2d(0.0,0.0);
	glVertex3f(-size.x+position.x, size.y+position.y,  size.z+position.z);
	glNormal3f( 0, 1, 0 );
	glTexCoord2d(1.0,0.0);
	glVertex3f( size.x+position.x, size.y+position.y,  size.z+position.z);

	//bottom
	glNormal3f( 0, -1, 0 );
	glTexCoord2d(1.0,1.0);
	glVertex3f( size.x+position.x, -size.y+position.y,  size.z+position.z);
	glNormal3f( 0, -1, 0 );
	glTexCoord2d(0.0,1.0);
	glVertex3f(-size.x+position.x, -size.y+position.y,  size.z+position.z);
	glNormal3f( 0, -1, 0 );
	glTexCoord2d(0.0,0.0);
	glVertex3f(-size.x+position.x, -size.y+position.y, -size.z+position.z);
	glNormal3f( 0, -1, 0 );
	glTexCoord2d(1.0,0.0);
	glVertex3f( size.x+position.x, -size.y+position.y, -size.z+position.z);

	glColor4ub(brightColor.r, brightColor.g, brightColor.b, brightColor.a);
	//front
	glNormal3f( 0, 0, 1 );
	glTexCoord2d(1.0,1.0);
	glVertex3f( size.x+position.x,  size.y+position.y, size.z+position.z);
	glNormal3f( 0, 0, 1 );
	glTexCoord2d(0.0,1.0);
	glVertex3f(-size.x+position.x,  size.y+position.y, size.z+position.z);
	glNormal3f( 0, 0, 1 );
	glTexCoord2d(0.0,0.0);
	glVertex3f(-size.x+position.x, -size.y+position.y, size.z+position.z);
	glNormal3f( 0, 0, 1 );
	glTexCoord2d(1.0,0.0);
	glVertex3f( size.x+position.x, -size.y+position.y, size.z+position.z);

	glColor4ub(darkColor.r, darkColor.g, darkColor.b, darkColor.a);
	//back
	glNormal3f( 0, 0, -1 );
	glTexCoord2d(1.0,1.0);
	glVertex3f( size.x+position.x, -size.y+position.y, -size.z+position.z);
	glNormal3f( 0, 0, -1 );
	glTexCoord2d(0.0,1.0);
	glVertex3f(-size.x+position.x, -size.y+position.y, -size.z+position.z);
	glNormal3f( 0, 0, -1 );
	glTexCoord2d(0.0,0.0);
	glVertex3f(-size.x+position.x,  size.y+position.y, -size.z+position.z);
	glNormal3f( 0, 0, -1 );
	glTexCoord2d(1.0,0.0);
	glVertex3f( size.x+position.x,  size.y+position.y, -size.z+position.z);

	//left
	glColor4ub(brightColor.r, brightColor.g, brightColor.b, brightColor.a);
	glNormal3f( -1, 0, 0 );
	glTexCoord2d(1.0,1.0);
	glVertex3f(-size.x+position.x,  size.y+position.y,  size.z+position.z);
	glNormal3f( -1, 0, 0 );
	glTexCoord2d(0.0,1.0);
	glVertex3f(-size.x+position.x,  size.y+position.y, -size.z+position.z);
	glNormal3f( -1, 0, 0 );
	glTexCoord2d(0.0,0.0);
	glVertex3f(-size.x+position.x, -size.y+position.y, -size.z+position.z);
	glNormal3f( -1, 0, 0 );
	glTexCoord2d(1.0,0.0);
	glVertex3f(-size.x+position.x, -size.y+position.y,  size.z+position.z);

	glColor4ub(darkColor.r, darkColor.g, darkColor.b, darkColor.a);
	//right
	glNormal3f( 1, 0, 0 );
	glTexCoord2d(1.0,1.0);
	glVertex3f(size.x+position.x,  size.y+position.y, -size.z+position.z);
	glNormal3f( 1, 0, 0 );
	glTexCoord2d(0.0,1.0);
	glVertex3f(size.x+position.x,  size.y+position.y,  size.z+position.z);
	glNormal3f( 1, 0, 0 );
	glTexCoord2d(0.0,0.0);
	glVertex3f(size.x+position.x, -size.y+position.y,  size.z+position.z);
	glNormal3f( 1, 0, 0 );
	glTexCoord2d(1.0,0.0);
	glVertex3f(size.x+position.x, -size.y+position.y, -size.z+position.z);
	glEnd();
}

var demoPlayer = undefined;

function drawCircle(animation)
{

	//var position = 2;
	var percent = animation.endPercent;
	var startPointPercent= animation.startPercent;

	//perspective2dBegin(getScreenWidth(),getScreenHeight());

	var CIRCLE_PRECISION = 100;
	glPushMatrix();
	//glTranslatef(getScreenWidth()/2, getScreenHeight()/2, 0);
	//glRotatef(360/3.*position,0,0,1);
	var radius = 1;	
	//glColor3f(1,0,0);
	glBegin(GL_TRIANGLES);
	
	var time = getSceneTimeFromStart();
	var fade = (time-animation.start)/0.75;
	if (fade > 1) { fade = 1; }

	percent *= fade;

    var brightColor = demoPlayer.calculateColorAnimation(time, animation, animation.color);
    var darkColor = Utils.deepCopyJson(brightColor);
    var darkness = 0.4;
    darkColor.r *= darkness;
    darkColor.g *= darkness;
    darkColor.b *= darkness;

	for (var i=0; i < CIRCLE_PRECISION*percent; i++)
	{
		var angle = (i+CIRCLE_PRECISION*startPointPercent)*2*Math.PI/CIRCLE_PRECISION;
		var angle2 = ((i+1)+CIRCLE_PRECISION*startPointPercent)*2*Math.PI/CIRCLE_PRECISION;
		var triangle = {
			"x1": Math.sin(angle) * radius, "y1": Math.cos(angle) * radius,
			"x2": Math.sin(angle2) * radius, "y2": Math.cos(angle2) * radius
		}

	    glColor4ub(brightColor.r, brightColor.g, brightColor.b, brightColor.a);
		//top
		glVertex3f(triangle.x1, triangle.y1, 0);
		glVertex3f(triangle.x2, triangle.y2, 0);
		glVertex3f(0,0,0);

    	glColor4ub(darkColor.r, darkColor.g, darkColor.b, darkColor.a);
		//bottom
		var z = -0.75;
		glVertex3f(triangle.x1, triangle.y1, z);
		glVertex3f(triangle.x2, triangle.y2, z);
		glVertex3f(0,0,z);

		//outer ring
		glVertex3f(triangle.x2, triangle.y2, 0);
		glVertex3f(triangle.x2, triangle.y2, z);
		glVertex3f(triangle.x1, triangle.y1, 0);

		glVertex3f(triangle.x1, triangle.y1, z);
		glVertex3f(triangle.x1, triangle.y1, 0);
		glVertex3f(triangle.x2, triangle.y2, z);
	}
	glEnd();
	
	//glPushMatrix();
	/*var angle = (CIRCLE_PRECISION*percent+CIRCLE_PRECISION*startPointPercent)*2*Math.PI/CIRCLE_PRECISION;
	glTranslatef(-(jml_ball.w/2.)+Math.cos(angle) * radius,-(jml_ball.h/2.)+Math.sin(angle) * radius * 3.5, 0);

	glColor3f(1,1,1);
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, jml_ball.id);
	glBegin(GL_QUADS);
	glTexCoord2f(1.0,1.0);
	glVertex2f(jml_ball.w,jml_ball.h);
	glTexCoord2f(0.0,1.0);
	glVertex2f(0,jml_ball.h);
	glTexCoord2f(0.0,0.0);
	glVertex2f(0, 0);
	glTexCoord2f(1.0,0.0);
	glVertex2f(jml_ball.w,0);
	glEnd();
	glDisable(GL_TEXTURE_2D);
	glPopMatrix();

	glPopMatrix();*/

	//perspective2dEnd();

	glPopMatrix();
}

function drawCircleLegend(animation)
{
	glPushMatrix();

	perspective2dBegin(getScreenWidth(),getScreenHeight());


	glDisable(GL_BLEND);
	glLineWidth(2.0);

	var time = getSceneTimeFromStart();
    var color = demoPlayer.calculateColorAnimation(time, animation, animation.color);
    var position = demoPlayer.calculatePositionAnimation(time, animation, animation.position);

    glColor4ub(color.r, color.g, color.b, color.a);

    glBegin(GL_QUADS);
    glVertex2f(position.x-80, position.y-20);
    glVertex2f(position.x-80, position.y+20);
    glVertex2f(position.x-130, position.y+20);
    glVertex2f(position.x-130, position.y-20);
    glEnd();
	
    glColor4ub(0,0,0, color.a);

    glBegin(GL_LINE_LOOP);
    glVertex2f(position.x-80, position.y-20);
    glVertex2f(position.x-80, position.y+20);
    glVertex2f(position.x-130, position.y+20);
    glVertex2f(position.x-130, position.y-20);
    glEnd();



	perspective2dEnd();

	glPopMatrix();
}

Demo.prototype.addPieChart = function(animation) {
	var startPercent = 0.0;
	for(var portion_i = 0; portion_i < animation.portions.length; portion_i++) {
		var portion = animation.portions[portion_i];
		var endPercent = portion["percent"];
		var portionAnimation = Utils.deepCopyJson(animation);
		portionAnimation["object"] = portionAnimation["object"] + portion_i;
		portionAnimation["color"] = Utils.deepCopyJson(portion.color);
		portionAnimation["startPercent"] = startPercent;
		portionAnimation["endPercent"] = endPercent;
		this.loader.addAnimation([portionAnimation]);
		startPercent += portion["percent"];

		var portionDelay = portion_i*0.75;
		this.loader.addAnimation([
		{
			 "start": portionAnimation["start"]+portionDelay
			,"duration": portionAnimation["duration"]-portionDelay
			,"layer": portionAnimation["layer"]
			,"color": Utils.deepCopyJson(portion.color)
			,"scale": [{"uniform2d":0.7}]
			,"position": [{"x":portionAnimation.textStartPosition.x,"y":portionAnimation.textStartPosition.y-(getScreenHeight()*0.1*portion_i)}]
			,"runFunction": "{drawCircleLegend(animation);}"
		}]);

		var textColor = Utils.deepCopyJson(portion.color);
		for (var textColor_i = 0; textColor_i < textColor.length; textColor_i++) {
			textColor[textColor_i].r = fontSecondaryColor.r;
			textColor[textColor_i].g = fontSecondaryColor.g;
			textColor[textColor_i].b = fontSecondaryColor.b;
		}
		this.loader.addAnimation([
		{
			 "start": portionAnimation["start"]+portionDelay
			,"duration": portionAnimation["duration"]-portionDelay
			,"layer": portionAnimation["layer"]
			,"text":{"name":fontName,"string":portion["label"]}
			,"color": textColor
			,"scale": [{"uniform2d":0.7}]
			,"position": [{"x":portionAnimation.textStartPosition.x+100,"y":portionAnimation.textStartPosition.y-(getScreenHeight()*0.1*portion_i)}]
		}]);
	}
}

Demo.prototype.addBarChart = function(animation) {
	for(var portion_i = 0; portion_i < animation.portions.length; portion_i++) {
		var portion = animation.portions[portion_i];
//		endPercent = portion["percent"];
		var portionAnimation = Utils.deepCopyJson(animation);
		portionAnimation["object"] = portionAnimation["object"] + portion_i;
		portionAnimation["color"] = Utils.deepCopyJson(portion.color);
		portionAnimation.initialSize.y *= portion["percent"];
		portionAnimation.initialPosition.x += portion_i*(portionAnimation.initialSize.x*3);
		portionAnimation.initialPosition.y += portionAnimation.initialSize.y;
//		portionAnimation["startPercent"] = startPercent;
//		portionAnimation["endPercent"] = endPercent;
		this.loader.addAnimation([portionAnimation]);
//		startPercent += portion["percent"];

		var portionDelay = portion_i*0.75;
		this.loader.addAnimation([
		{
			 "start": portionAnimation["start"]+portionDelay
			,"duration": portionAnimation["duration"]-portionDelay
			,"layer": portionAnimation["layer"]
			,"color": Utils.deepCopyJson(portion.color)
			,"scale": [{"uniform2d":0.7}]
			,"position": [{"x":portionAnimation.textStartPosition.x,"y":portionAnimation.textStartPosition.y-(getScreenHeight()*0.1*portion_i)}]
			,"runFunction": "{drawCircleLegend(animation);}"
		}]);

		var textColor = Utils.deepCopyJson(portion.color);
		for (var textColor_i = 0; textColor_i < textColor.length; textColor_i++) {
			textColor[textColor_i].r = fontSecondaryColor.r;
			textColor[textColor_i].g = fontSecondaryColor.g;
			textColor[textColor_i].b = fontSecondaryColor.b;
		}
		this.loader.addAnimation([
		{
			 "start": portionAnimation["start"]+portionDelay
			,"duration": portionAnimation["duration"]-portionDelay
			,"layer": portionAnimation["layer"]
			,"text":{"name":fontName,"string":portion["label"]}
			,"color": textColor
			,"scale": [{"uniform2d":0.7}]
			,"position": [{"x":portionAnimation.textStartPosition.x+100,"y":portionAnimation.textStartPosition.y-(getScreenHeight()*0.1*portion_i)}]
		}]);
	}
}

function drawQuadrantGrid(animation)
{
	//glPushAttrib(GL_CURRENT_BIT);

	perspective2dBegin(getScreenWidth(),getScreenHeight());

	glPushMatrix();

	var time = getSceneTimeFromStart();
	var p = Utils.calculateProgress(animation.start, 0.5);
	if (p > 1) {p = 1;}

    var color = demoPlayer.calculateColorAnimation(time, animation, animation.color);
    //var position = demoPlayer.calculatePositionAnimation(time, animation, animation.position);
    var origo = animation.origo;
    var size = Utils.deepCopyJson(animation.size);
    var size2 = Utils.deepCopyJson(animation.size);

    glEnable(GL_BLEND);
    glColor4ub(color.r, color.g, color.b, color.a*p);
	
	//glDisable(GL_BLEND);
	glLineWidth(2.0);

	size2.w *= p;
	size2.h *= p;
    //glColor4ub(255,0,0, color.a);

    glBegin(GL_LINE_LOOP);
    glVertex2f(origo.x-size.w/2, origo.y-size.h/2);
    glVertex2f(origo.x-size.w/2, origo.y+size.h/2);
    glVertex2f(origo.x+size.w/2, origo.y+size.h/2);
    glVertex2f(origo.x+size.w/2, origo.y-size.h/2);
    glEnd();

    glBegin(GL_LINES);
    glVertex2f(origo.x-size2.w/2, origo.y);
    glVertex2f(origo.x+size2.w/2, origo.y);

    glVertex2f(origo.x, origo.y-size2.h/2);
    glVertex2f(origo.x, origo.y+size2.h/2);
    glEnd();

	glDisable(GL_BLEND);
	glPopMatrix();

	perspective2dEnd();
}

Demo.prototype.addMagicQuadrant = function(start, duration) {
	var layer = 1;
	var color = [ {"r":fontSecondaryColor.r,"g":fontSecondaryColor.g,"b":fontSecondaryColor.b,"a":0}, {"duration":1,"a":255} ];
	this.loader.addAnimation(
	[{
		 "start": start, "duration": duration
		,"object":"quadrant","shape":{"type":"CUSTOM"}
		,"layer": layer
		,"color": color
		,"shadowFakery":true
    	,"origo": {"x":getScreenWidth()/2, "y":getScreenHeight()/2}
    	,"size": {"w":getScreenWidth()*0.88, "h":getScreenHeight()*0.88}
		,"runFunction":"{drawQuadrantGrid(animation);}"
	}]);

	// Title labels

	this.loader.addAnimation([
	{
		 "start": start, "duration": duration
		,"layer": layer, "text":{"name":fontName,"string":"Ability to Execute"}
		,"color": color
		,"scale": [{"uniform2d":0.5}]
		,"position": [{"x":50,"y":getScreenHeight()/2}]
		,"angle": [{"degreesZ":-90}]
	}]);

	this.loader.addAnimation([
	{
		 "start": start, "duration": duration
		,"layer": layer, "text":{"name":fontName,"string":"Completeness of Vision"}
		,"color": color
		,"scale": [{"uniform2d":0.5}]
		,"position": [{"x":getScreenWidth()/2,"y":25}]
		,"angle": [{"degreesZ":0}]
	}]);

	//Sectors

	this.loader.addAnimation([
	{
		 "start": start, "duration": duration
		,"layer": layer, "text":{"name":fontName,"string":"Challengers"}
		,"color": color
		,"scale": [{"uniform2d":0.5}]
		,"position": [{"x":getScreenWidth()*0.25,"y":getScreenHeight()*0.75}]
		,"angle": [{"degreesZ":0}]
	}]);

	this.loader.addAnimation([
	{
		 "start": start, "duration": duration
		,"layer": layer, "text":{"name":fontName,"string":"Niche"}
		,"color": color
		,"scale": [{"uniform2d":0.5}]
		,"position": [{"x":getScreenWidth()*0.25,"y":getScreenHeight()*0.25}]
		,"angle": [{"degreesZ":0}]
	}]);

	this.loader.addAnimation([
	{
		 "start": start, "duration": duration
		,"layer": layer, "text":{"name":fontName,"string":"Leaders"}
		,"color": color
		,"scale": [{"uniform2d":0.5}]
		,"position": [{"x":getScreenWidth()*0.75,"y":getScreenHeight()*0.75}]
		,"angle": [{"degreesZ":0}]
	}]);

	this.loader.addAnimation([
	{
		 "start": start, "duration": duration
		,"layer": layer, "text":{"name":fontName,"string":"Visionaries"}
		,"color": color
		,"scale": [{"uniform2d":0.5}]
		,"position": [{"x":getScreenWidth()*0.75,"y":getScreenHeight()*0.25}]
		,"angle": [{"degreesZ":0}]
	}]);
}

function getTwisterTwists(animation)
{
	var percent = Math.min(Math.max((((getSceneTimeFromStart()-animation.start-animation.twist1Start)/(animation.twist1Duration))), 0.0), 1.0);
	var twists = 30*percent;
	if (percent >= 1.0) {
		percent = Math.min(Math.max((((getSceneTimeFromStart()-animation.start-animation.twist2Start)/(animation.twist2Duration))), 0.0), 1.0);
		twists += -90*percent;
	}
	return twists;
}

function getTwisterRotateY(animation)
{
	return ((Math.sin(getSceneTimeFromStart())+1)/5.0)*360*2;
}

function getTwisterRotateX(animation)
{
	return ((Math.sin(getSceneTimeFromStart())+1)/5.0)*360*2;
}

function getTwisterDisplacementMagnitude(animation)
{
	var time = getSceneTimeFromStart()-animation.start-animation.displacementStart;
	if (time < 0)
	{
		return 0;
	}

	return 1;//10+(Math.sin(time)-1)*6;
}

function getTwisterDisplacementMultiplier(animation)
{
	var time = getSceneTimeFromStart()-animation.start-animation.displacementStart;
	if (time < 0)
	{
		return 0;
	}

	return 0.1*((Math.sin(time)+1)/2.0);
}

//var gateTextFbo;
var tailLightPathDefinition = [];
var tailLightPath;

var frontLightPathDefinition = [];
var frontLightPath;
function initCarLights(animation)
{
	/*if (gateTextFbo != null)
	{
		return;
	}*/

	//literatureReferences = readFile("data/onenationundergod.raw");

	//gateTextFbo = fboInit("gateTextFbo");

	var stepCount = 14.0;
	var subStepPrecision = 10;

	for(var i = 0; i <= stepCount; i++)
	{
		var start = -1.5;
		var size = 3.1;
		var step = size/stepCount;
		tailLightPathDefinition.push({"x":getScreenWidth()*0.9, "y":0, "z":0});
	}
	var i = 0;
	i++;
	tailLightPathDefinition[i].x += -10;
	tailLightPathDefinition[i].y += 50;
	i++;
	tailLightPathDefinition[i].x += -60;
	tailLightPathDefinition[i].y += 120;
	i++;
	tailLightPathDefinition[i].x += -90;
	tailLightPathDefinition[i].y += 160;
	i++;
	tailLightPathDefinition[i].x += -130;
	tailLightPathDefinition[i].y += 200;
	i++;
	tailLightPathDefinition[i].x += -180;
	tailLightPathDefinition[i].y += 250;
	i++;
	tailLightPathDefinition[i].x += -210;
	tailLightPathDefinition[i].y += 280;
	i++;
	tailLightPathDefinition[i].x += -240;
	tailLightPathDefinition[i].y += 310;

	i++;
	tailLightPathDefinition[i].x += -270;
	tailLightPathDefinition[i].y += 340;
	i++;
	tailLightPathDefinition[i].x += -300;
	tailLightPathDefinition[i].y += 370;
	i++;
	tailLightPathDefinition[i].x += -300;
	tailLightPathDefinition[i].y += 400;
	i++;
	tailLightPathDefinition[i].x += -270;
	tailLightPathDefinition[i].y += 420;
	i++;
	tailLightPathDefinition[i].x += -240;
	tailLightPathDefinition[i].y += 430;
	i++;
	tailLightPathDefinition[i].x += -200;
	tailLightPathDefinition[i].y += 440;
	i++;
	tailLightPathDefinition[i].x += -180;
	tailLightPathDefinition[i].y += 450;

	var catmullRomPath = new CatmullRomSpline()
	tailLightPath = catmullRomPath.calculateSpline(tailLightPathDefinition, subStepPrecision);

	stepCount = 12.0;

	for(var i = 0; i <= stepCount; i++)
	{
		var start = -1.5;
		var size = 3.1;
		var step = size/stepCount;
		frontLightPathDefinition.push({"x":getScreenWidth()*0.99, "y":150, "z":0});
	}
	var i = 0;
	i++;
	frontLightPathDefinition[i].x += -50;
	frontLightPathDefinition[i].y += 30;
	i++;
	frontLightPathDefinition[i].x += -110;
	frontLightPathDefinition[i].y += 70;
	i++;
	frontLightPathDefinition[i].x += -160;
	frontLightPathDefinition[i].y += 100;
	i++;
	frontLightPathDefinition[i].x += -230;
	frontLightPathDefinition[i].y += 140;
	i++;
	frontLightPathDefinition[i].x += -300;
	frontLightPathDefinition[i].y += 180;
	i++;
	frontLightPathDefinition[i].x += -360;
	frontLightPathDefinition[i].y += 220;
	i++;
	frontLightPathDefinition[i].x += -370;
	frontLightPathDefinition[i].y += 250;
	i++;
	frontLightPathDefinition[i].x += -340;
	frontLightPathDefinition[i].y += 270;
	i++;
	frontLightPathDefinition[i].x += -300;
	frontLightPathDefinition[i].y += 280;
	i++;
	frontLightPathDefinition[i].x += -270;
	frontLightPathDefinition[i].y += 290;
	i++;
	frontLightPathDefinition[i].x += -270;
	frontLightPathDefinition[i].y += 305;
	i++;
	frontLightPathDefinition[i].x += -310;
	frontLightPathDefinition[i].y += 318;

	var catmullRomPath = new CatmullRomSpline()
	frontLightPath = catmullRomPath.calculateSpline(frontLightPathDefinition, subStepPrecision);
}

function drawCarLights(animation)
{
	glPushMatrix();

	perspective2dBegin(getScreenWidth(),getScreenHeight());

	glLineWidth(9.0);
	var time = getSceneTimeFromStart();
	//glEnable(GL_TEXTURE_2D);
	glEnable(GL_BLEND);
	//fboBindTextures(gateTextFbo.ptr);

	for(var i = 0; i < tailLightPath.length-1; i+=1)
	{
		var pu0 = tailLightPath[i];
		var pu1 = tailLightPath[i+1];

		var percentStep = 1/(tailLightPath.length-1);
		var percent = (i+1)/(tailLightPath.length-1);

		var dx = Math.sin(time*10+i/tailLightPath.length*10)*2;
		var dy = Math.cos(time*10+i/tailLightPath.length*10)*1;

		glColor4f(1,0,0,1*((Math.sin(-time*49+i/tailLightPath.length*40)+1)/2.));

		glBegin(GL_LINES);
		glVertex3d(pu1.x+dx, pu1.y+dy, pu1.z); 
		glVertex3d(pu0.x+dx, pu0.y+dy, pu0.z); 
		glEnd();

		glColor4f(1,0,0,1*((Math.sin((-time-2)*51+i/tailLightPath.length*42)+1)/2.));

		dx = Math.sin(time*10+i/tailLightPath.length*13)*2;
		dx -= 8;
		glBegin(GL_LINES);
		glVertex3d(pu1.x+dx, pu1.y+dy, pu1.z); 
		glVertex3d(pu0.x+dx, pu0.y+dy, pu0.z); 
		glEnd();

		glColor4f(1,0,0,1*((Math.sin((-time+6.8)*52+i/tailLightPath.length*37)+1)/2.));

		dx = Math.sin(time*10+i/tailLightPath.length*11)*2;
		dx -= 16;
		glBegin(GL_LINES);
		glVertex3d(pu1.x+dx, pu1.y+dy, pu1.z); 
		glVertex3d(pu0.x+dx, pu0.y+dy, pu0.z); 
		glEnd();
	}

	for(var i = 0; i < frontLightPath.length-1; i+=1)
	{
		var pu0 = frontLightPath[i];
		var pu1 = frontLightPath[i+1];

		var percentStep = 1/(frontLightPath.length-1);
		var percent = (i+1)/(frontLightPath.length-1);

		var dx = Math.sin(time*10+i/tailLightPath.length*10)*2;
		var dy = Math.cos(time*10+i/tailLightPath.length*10)*1;

		glColor4f(1,1,1,1*((Math.sin(time*49+i/tailLightPath.length*40)+1)/2.));
		glBegin(GL_LINES);
		glVertex3d(pu1.x+dx, pu1.y+dy, pu1.z); 
		glVertex3d(pu0.x+dx, pu0.y+dy, pu0.z); 
		glEnd();
		dx = Math.sin(time*10+i/tailLightPath.length*13)*2;
		dx -= 8;
		glColor4f(1,1,1,1*((Math.sin((time-2)*51+i/tailLightPath.length*42)+1)/2.));
		glBegin(GL_LINES);
		glVertex3d(pu1.x+dx, pu1.y+dy, pu1.z); 
		glVertex3d(pu0.x+dx, pu0.y+dy, pu0.z); 
		glEnd();
		dx = Math.sin(time*10+i/tailLightPath.length*11)*2;
		dx -= 16;
		glColor4f(1,1,1,1*((Math.sin((time+6.8)*52+i/tailLightPath.length*37)+1)/2.));
		glBegin(GL_LINES);
		glVertex3d(pu1.x+dx, pu1.y+dy, pu1.z); 
		glVertex3d(pu0.x+dx, pu0.y+dy, pu0.z); 
		glEnd();
	}

	//glDisable(GL_TEXTURE_2D);
	glDisable(GL_BLEND);

	perspective2dEnd();

	glPopMatrix();
}

function getGlowValue(animation, type, name)
{
	//var p = 1-Utils.calculateProgress(animation.start, animation.duration);

	var samples = 10;
	var spread = 0.0015;
	var intensity = 0.35;
	var alpha = 1;

	if (name === "samples")
	{
		return samples;
	}
	else if (name === "spread")
	{
		if (type == 0)
		{
			return spread*1.1;
		}
		else if (type == 1)
		{
			return spread*0.1;
		}
		return spread;
	}
	else if (name === "intensity")
	{
		if (type == 0)
		{
			return intensity*1.6;
		}
		else if (type == 1)
		{
			return intensity*11;
		}
		return intensity;
	}
	else if (name === "alpha")
	{
		return alpha;
	}
	else if (name === "glowAlpha")
	{
		return 1.0;
	}
	else if (name === "showOnlyGlow")
	{
		/*if (p < 1.0)
		{
			return 1;
		}*/
		return 1;
	}
	
	return void null;
}


Demo.prototype.preInitCarLights = function(start, duration) {
	var scale = 0.60;
	var layer = 1;
	this.loader.addAnimation([
	{
		 "start": start, "duration": duration
		,"layer": layer
		,"initFunction":"{initCarLights(animation);}"
		,"runFunction":"{drawCarLights(animation);}"
		,"passToFbo": {name:"carLightsFboFirstPass"}
	}]);

	var samples = 12;
	var spread = 0.005;
	var intensity = 0.14;
	var alpha = 0.7;

	this.loader.addAnimation([{
		 "start": start, "duration": duration
		,"layer": layer
		,"image": "carLightsFboFirstPass.color.fbo"
		,"passToFbo": {name:"carLightsFbo"}
		,"shader":[
			 {"name":"data/shader/glow.fs","variable":[
				 {"name":"direction","value":[0,1]}
				,{"name":"glowAlpha","value":["{return getGlowValue(animation, 0, \"glowAlpha\");}"]}
				,{"name":"spread","value":["{return getGlowValue(animation, 0, \"spread\");}"]}
				,{"name":"intensity","value":["{return getGlowValue(animation, 0, \"intensity\");}"]}
				,{"name":"samples","type":"int","value":["{return getGlowValue(animation, 0, \"samples\");}"]}
			]}
			,{"name":"data/shader/glow.fs","variable":[
				 {"name":"direction","value":[1,0]}
				,{"name":"glowAlpha","value":["{return getGlowValue(animation, 1, \"glowAlpha\");}"]}
				,{"name":"spread","value":["{return getGlowValue(animation, 1, \"spread\");}"]}
				,{"name":"intensity","value":["{return getGlowValue(animation, 1, \"intensity\");}"]}
				,{"name":"samples","type":"int","value":["{return getGlowValue(animation, 1, \"samples\");}"]}
				,{"name":"showOnlyGlow","type":"int","value":["{return getGlowValue(animation, 1, \"showOnlyGlow\");}"]}
				,{"name":"alpha","value":["{return getGlowValue(animation, 1, \"alpha\");}"]}
			]}
		]
	}]);

	this.loader.addAnimation([
	{
		 "start": start, "duration": duration
		,"layer": layer+1
		,"image": "data/blank.png"
		,"shader":{"name":"data/shader/background.fs",
			"variable":[
			    {"name":"time","value":["{return getSceneTimeFromStart();}"]}
			    ,{"name":"gradient","type":"int","value":[0]}
			]
		}
		,"color": [{"a":120}]
	}]);


	this.loader.addAnimation([
	{
		 "start": start, "duration": duration
		//,"position": [{"x":getScreenWidth()*0.1,"y":getScreenHeight()*0.44}]
		,"image": "data/highway.png"
		//,"scale": [{"uniform2d":0.5}]
		,"layer": layer+1
		,"color":[{},{"duration":duration-0.5},{"a":0,"duration":0.5}]
	}]);


	this.loader.addAnimation([{
		 "start": start, "duration": duration
		,"layer": layer+1
		,"image": "carLightsFboFirstPass.color.fbo"
		,"color":[{},{"duration":duration-0.5},{"a":0,"duration":0.5}]
	}]);

	this.loader.addAnimation([{
		 "start": start, "duration": duration
		,"layer": layer+1
		,"image": "carLightsFbo.color.fbo"
		,"color":[{"a":90},{"duration":duration-0.5},{"a":0,"duration":0.5}]
	}]);
}

Demo.prototype.preInitSkyscraper = function(start, duration) {
	var layer = 1;

	//skyscraper
	this.loader.addAnimation([
	{
		 "start": start, "duration": duration
		,"perspective":"3d"
		//,"position": [{"z":-1.0},{"start":dropStart, "duration":dropTime, "z":-10.0}]
		,"position": [{"z":-7.0}]
		,"angle": [{"degreesX":-40, "degreesY":-10}]
		,"image": "data/clouds_01.png"
		,"scale": [{"uniform2d":20}]
		//,"color": [{"a":155},{"duration":durationTime-FADE},{"duration":FADE,"a":0}]
		,"uvSpeed": 0.05
		,"uvMax": 2
		,"uv": {
			 "uMin": "{return (getSceneTimeFromStart()*animation.uvSpeed)%animation.uvMax-animation.uvMax;}"
			,"vMin": "{return (getSceneTimeFromStart()*animation.uvSpeed)%animation.uvMax-animation.uvMax;}"
			,"uMax": "{return (getSceneTimeFromStart()*animation.uvSpeed)%animation.uvMax;}"
			,"vMax": "{return (getSceneTimeFromStart()*animation.uvSpeed)%animation.uvMax;}"
		}
		,"shader":{"name":"data/shader/sky.fs",
			"variable":[
			    {"name":"time","value":["{return getSceneTimeFromStart();}"]}
			]
		}
		,"layer": layer
		,"color":[{"a":0},{"duration":0.5,"a":255},{"duration":duration-1},{"a":0,"duration":0.5}]
	}]);

	this.loader.addAnimation([
	{
		 "start": start, "duration": duration
		,"position": [{"x":getScreenWidth()*0.1,"y":getScreenHeight()*0.44}]
		,"image": "data/skyscraper.png"
		,"scale": [{"uniform2d":0.5}]
		,"layer": layer
		,"color":[{"a":0},{"duration":0.5,"a":255},{"duration":duration-1},{"a":0,"duration":0.5}]
	}]);

	this.loader.addAnimation([
	{
		 "start": start, "duration": duration
		,"position": [{"x":getScreenWidth()*0.1,"y":getScreenHeight()*0.44}]
		,"image": ["data/skyscraper_windows.png","data/clouds_01.png"]
		,"scale": [{"uniform2d":0.5}]
		,"layer": layer
		,"shader":{"name":"data/shader/reflection.fs",
			"variable":[
				 {"name":"time","value":["{return getSceneTimeFromStart()*2;}"]}
				,{"name":"texture1","type":"int","value":[0]}
				,{"name":"texture2","type":"int","value":[1]}
				,{"name":"y","value":["{var p = (getSceneTimeFromStart()-animation.start)/animation.fade; return p;}"]}
			]
		}
		,"color":[{"a":0},{"duration":0.5,"a":255},{"duration":duration-1},{"a":0,"duration":0.5}]
	}]);

	var pictures = [
		"data/street.png",
		"data/people_agreement.png",
		"data/meetings.png",
		"data/city.png",
		"data/people_thumbs.png",
		"data/nature.png"
	];

	var picturesStart = start+11.25;
	this.loader.addAnimation([
	{
		 "start": picturesStart, "duration": duration
		,"position": [{"x":getScreenWidth()*0.35,"y":getScreenHeight()*0.85}]
		,"image": randomPopAnswer(pictures)
		,"scale": [{"uniform2d":0.25}]
		,"color": [{"a":0},{"duration":0.25,"a":255},{"duration":3},{"duration":0.5,"a":0}]
		,"layer": layer
	}]);
	this.loader.addAnimation([
	{
		 "start": picturesStart+3.0, "duration": duration
		,"position": [{"x":getScreenWidth()*0.85,"y":getScreenHeight()*0.85}]
		,"image": randomPopAnswer(pictures)
		,"scale": [{"uniform2d":0.25}]
		,"color": [{"a":0},{"duration":0.25,"a":255},{"duration":3},{"duration":0.5,"a":0}]
		,"layer": layer
	}]);
	this.loader.addAnimation([
	{
		 "start": picturesStart+6, "duration": duration
		,"position": [{"x":getScreenWidth()*0.85,"y":getScreenHeight()*0.15}]
		,"image": randomPopAnswer(pictures)
		,"scale": [{"uniform2d":0.25}]
		,"color": [{"a":0},{"duration":0.25,"a":255},{"duration":3},{"duration":0.5,"a":0}]
		,"layer": layer
	}]);
}

Demo.prototype.preInitFinalProduct = function(start, duration) {
	var layer = 1;
	this.loader.addAnimation([
	{
		 "start": start, "duration": duration
		,"layer": layer
		,"fbo":{"name":"finalProductFbo","action":"begin"}
	}]);

	this.loader.addAnimation([
	{
		 "start": start, "duration": duration
		,"layer": layer
		,"image": "data/blank.png"
		,"shader":{"name":"data/shader/background.fs",
			"variable":[
			    {"name":"time","value":["{return getSceneTimeFromStart();}"]}
			]
		}
		,"color": [{"r":255,"a":255}]
	}]);

	var loadingTime = 3;
	this.loader.addAnimation([
	{
		 "start": start, "duration": loadingTime
		,"layer": layer
		,"runFunction": "{Loader.drawLoadingBar(Utils.calculateProgress(animation.start, animation.duration));}"
	}]);

	//cube or something
	this.loader.addAnimation([
	{
		 "start": start+loadingTime, "duration": duration-loadingTime
		,"layer": layer
		,"image": "data/blank.png"
		,"twist1Start": 4,"twist1Duration": 5
		,"twist2Start": 9,"twist2Duration": 5
		,"displacementStart": 12.5
		,"shader":{"name":"data/shader/raymarching.fs",
			"variable":[
				 {"name":"time","value":["{return getSceneTimeFromStart();}"]}
				,{"name":"twisterTwists","value":["{return getTwisterTwists(animation);}"]}
				,{"name":"twisterRotateY","value":["{return getTwisterRotateY(animation);}"]}
				,{"name":"twisterRotateX","value":["{return getTwisterRotateX(animation);}"]}
				,{"name":"displacementMagnitude","value":["{return getTwisterDisplacementMagnitude(animation);}"]}
				,{"name":"displacementMultiplier","value":["{return getTwisterDisplacementMultiplier(animation);}"]}
			]
		}
		,"color":[{"a":255}]
	}]);

	this.loader.addAnimation([
	{
		 "start": start, "duration": duration
		,"layer": layer
		,"fbo":{"name":"finalProductFbo","action":"unbind"}
	}]);

	this.loader.addAnimation([{
		 "start": start, "duration": duration
		,"layer": layer
		,"image": "finalProductFbo.color.fbo"
		,"perspective":"3d"
		,"position": [{"x":-0.34,"y":-1.5,"z":-6.2}]
		,"angle": [{"degreesX":20,"degreesY":0}]
		,"scale": [{"uniform2d":1.1}]
	}]);

	this.loader.addAnimation([{
		 "start": start, "duration": duration
		,"layer": layer
		,"image": "finalProductFbo.color.fbo"
		,"perspective":"3d"
		,"position": [{"x":1.7,"y":-2.5,"z":-6.2}]
		,"angle": [{"degreesX":80,"degreesY":0,"degreesZ":88}]
		,"scale": [{"uniform2d":0.9}]
	}]);
	this.loader.addAnimation([{
		 "start": start+loadingTime+2, "duration": duration-(loadingTime+2)
		,"layer": layer
		,"image": "data/bsod.png"
		,"perspective":"3d"
		,"position": [{"x":1.7,"y":-2.5,"z":-6.2}]
		,"angle": [{"degreesX":80,"degreesY":0,"degreesZ":88}]
		,"scale": [{"uniform2d":0.9}]
	}]);

	this.loader.addAnimation([
	{
		 "start": start, "duration": duration
		,"layer": layer
		,"image": "data/people_final_product.png"
	}]);

	this.loader.addAnimation([{
		 "start": start+11.25, "duration": duration-11.25
		,"layer": layer
		,"color":[{"a":0},{"duration":0.25,"a":255}]
		,"image": "finalProductFbo.color.fbo"
	}]);
}

var boatContainer;
var valuePropositionDrawContainer;
function initBoardDrawing(animation)
{
	boatContainer = loadSplineContainerFromFile("data/boat_draw.dat");
	valuePropositionDrawContainer = loadSplineContainerFromFile("data/proposition_draw.dat");
}

function drawBoardDrawing(animation)
{
	var duration = animation.duration;
	var pointer = boatContainer.ptr;
	if (animation.draw2 === true) {
		pointer = valuePropositionDrawContainer.ptr;
		duration = 10;
	}

	var animationProgress = (getSceneTimeFromStart()-animation.start)/duration;
	//animationProgress = 2.0;
	
	glEnable(GL_BLEND);
	glLineWidth(10);
		
	perspective2dBegin(getScreenWidth()*0.7, getScreenHeight()*0.7);
	glColor3f(0,0,0);

	glTranslatef(50,-50,0);
	drawSplineContainer(pointer, 0.0, animationProgress);


	perspective2dEnd();
	glDisable(GL_BLEND);
}

Demo.prototype.preInitProductPlanning = function(start, duration) {
	var layer = 1;

	this.loader.addAnimation([
	{
		 "start": start, "duration": duration
		,"layer": layer
		,"fbo":{"name":"productPlanningFbo","action":"begin"}
	}]);

	this.loader.addAnimation([
	{
		 "start": start, "duration": duration
		,"layer": layer
		,"image": "data/board_white.png"
	}]);

	this.loader.addAnimation([
	{
		 "start": start, "duration": 6
		,"layer": layer
		,"draw2": false
		,"initFunction":"{initBoardDrawing(animation);}"
		,"objectFunction":"{drawBoardDrawing(animation);}"
	}]);

	this.loader.addAnimation([
	{
		 "start": start+10.5, "duration": duration
		,"layer": layer
		,"draw2": true
		,"objectFunction":"{drawBoardDrawing(animation);}"
	}]);

	this.loader.addAnimation([
	{
		 "start": start, "duration": duration
		,"layer": layer
		,"fbo":{"name":"productPlanningFbo","action":"unbind"}
	}]);

	this.loader.addAnimation([{
		 "start": start, "duration": duration
		,"layer": layer
		,"image": "productPlanningFbo.color.fbo"
		,"perspective":"3d"
		,"position": [{"x":0.1,"y":0.60,"z":-1.8}]
		,"angle": [{"degreesX":5,"degreesY":0,"degreesZ":2}]
		,"scale": [{"uniform2d":1.08}]
	}]);

	this.loader.addAnimation([
	{
		 "start": start, "duration": duration
		,"layer": layer
		,"image": "data/people_negotiations.png"
	}]);

	this.loader.addAnimation([
	{
		 "start": start, "duration": duration
		,"layer": layer
		,"image": "data/white.png"
		,"color":[{"a":255},{"duration":0.5,"a":0},{"duration":duration-1},{"a":255,"duration":0.5}]
	}]);
}

Demo.prototype.preInitMagicQuadrant = function(start, duration) {
	var layer = 1;

	this.loader.addAnimation([
	{
		 "start": start, "duration": duration
		,"layer": layer
		,"fbo":{"name":"magicQuadrantFbo","action":"begin"}
	}]);

	this.addMagicQuadrant(start,duration);

	var groups = [
		{
			 "group":"jumalauta"
			,"position": [{"x":getScreenWidth()*0.90,"y":getScreenHeight()*0.85}]
		},
		{
			 "group":"mercury"
			,"position": [{"x":getScreenWidth()*0.1,"y":getScreenHeight()*0.13}]
		},
		{
			 "group":"kewlers"
			,"position": [{"x":getScreenWidth()*0.85,"y":getScreenHeight()*0.19}]
			,"color": [{"r":0, "g": 0, "b":0, "a":0}]
		},
		{
			 "group":"ivory_labs"
			,"position": [{"x":getScreenWidth()*0.3,"y":getScreenHeight()*0.19}]
			,"color": [{"r":0, "g": 0, "b":0, "a":0}]
		},
		{
			 "group":"conspiracy"
			,"position": [{"x":getScreenWidth()*0.13,"y":getScreenHeight()*0.29}]
			//,"color": [{"r":0, "g": 0, "b":0}]
		},
		{
			 "group":"satori"
			,"position": [{"x":getScreenWidth()*0.6,"y":getScreenHeight()*0.34}]
		},
		{
			 "group":"poobrain"
			,"position": [{"x":getScreenWidth()*0.6,"y":getScreenHeight()*0.7}]
			,"color": [{"r":100, "g":100, "b":100}]
		},
		{
			 "group":"accession"
			,"position": [{"x":getScreenWidth()*0.1,"y":getScreenHeight()*0.9}]
			//,"color": [{"r":50, "g":50, "b":50}]
		},
		{
			 "group":"darklite"
			,"position": [{"x":getScreenWidth()*0.4,"y":getScreenHeight()*0.7}]
			//,"color": [{"r":0, "g":0, "b":0}]
		},
		{
			 "group":"dekadence"
			,"position": [{"x":getScreenWidth()*0.3,"y":getScreenHeight()*0.83}]
			//,"color": [{"r":0, "g":0, "b":0}]
		},
		{
			 "group":"united"
			,"position": [{"x":getScreenWidth()*0.8,"y":getScreenHeight()*0.65}]
		}
	]

	for(var groups_i = 0; groups_i < groups.length; groups_i++) {
		var groupDetails = groups[groups_i];

		if (groupDetails.color === void null) {
			groupDetails.color = [{"r": 255, "g": 255, "b":255, "a":0}];
		}

		groupDetails.color.push({"duration":0.5,"a":255});

		var groupDelay = (groups_i*0.75);

		var group = {
			 "start": start+1.5+groupDelay, "duration": duration-groupDelay-1.5
			,"layer": layer
			,"image": "data/group_" + groupDetails.group + ".png"
			,"position": groupDetails.position
			,"scale": [{"uniform2d":0.2}]
			,"color": groupDetails.color
		};

		this.loader.addAnimation([group]);
	}

	this.loader.addAnimation([
	{
		 "start": start, "duration": duration
		,"layer": layer
		,"fbo":{"name":"magicQuadrantFbo","action":"unbind"}
	}]);
}

Demo.prototype.preInitCircleDiagram = function(start, duration) {
	var layer = 1;

	this.loader.addAnimation([
	{
		 "start": start, "duration": duration
		,"layer": layer
		,"fbo":{"name":"circleDiagramFbo","action":"begin"}
	}]);

	this.loader.addAnimation([
	{
		 "start":start, "duration": duration
		,"layer": layer
		,"image": "data/white.png"
	}]);

	this.addPieChart(
	{
		 "start": start, "duration": duration
		,"layer": layer
		,"object":"gate","shape":{"type":"CUSTOM"}
		//,"initFunction":"{initCarLights(animation);}"
		,"objectFunction":"{drawCircle(animation);}"
		,"position":[
			{"x":-1.5,"z":-2.0}
		],"angle":[
			 {"degreesY":20}
		]
		,"textStartPosition": {"x":getScreenWidth()*0.6,"y":getScreenHeight()*0.7}
		,"portions":[
			{
				 "label":randomPopAnswer(sceners)
				,"percent":0.25
				,"color":[{"r":0xef, "g": 0xe6, "b":0x03, "a":0xFF}]
			},
			{
				 "label":randomPopAnswer(sceners)
				,"percent":0.25
				,"color":[{"r":0xf7, "g": 0x94, "b":0x02, "a":0xFF}]
			},
			{
				 "label":randomPopAnswer(sceners)
				,"percent":0.25
				,"color":[{"r":0xc7, "g": 0x00, "b":0x45, "a":0xFF}]
			},
			{
				 "label":randomPopAnswer(sceners)
				,"percent":0.25
				,"color":[{"r":0x35, "g": 0x95, "b":0x0d, "a":0xFF}]
			}

		]
	});

	this.loader.addAnimation([
	{
		 "start": start, "duration": duration
		,"layer": layer
		,"fbo":{"name":"circleDiagramFbo","action":"unbind"}
	}]);
}

Demo.prototype.preInitBarChartDiagram = function(start, duration) {
	var layer = 1;

	this.loader.addAnimation([
	{
		 "start": start, "duration": duration
		,"layer": layer
		,"fbo":{"name":"barChartFbo","action":"begin"}
	}]);

	this.loader.addAnimation([
	{
		 "start":start, "duration": duration
		,"layer": layer
		,"image": "data/white.png"
	}]);

	this.addBarChart(
	{
		 "start": start, "duration": duration
		,"layer": layer
		,"object":"gate","shape":{"type":"CUSTOM"}
		,"shadowFakery":true
		//,"initFunction":"{initCarLights(animation);}"
		,"objectFunction":"{drawObjectCube(animation);}"
		,"position":[
			{"z":-6.0}
		]
		,"initialPosition":{"x":-3,"y":-1.5,"z":0}
		,"initialSize":{"x":0.5,"y":2,"z":0.5}
		/*,"angle":[
			{"degreesY":60,"degreesZ":-15}
		]*/
		,"portions":[
			{
				 "label":"INNOVATION"
				,"percent":0.2
				,"color":[{"r":255,"g":0,"b":0, "a":0xFF}]
			},
			{
				 "label":"SYNERGY"
				,"percent":0.34
				,"color":[{"r":0,"g":255,"b":0, "a":0xFF}]
			},
			{
				 "label":"ACTION"
				,"percent":0.9
				,"color":[{"r":0,"g":0,"b":255, "a":0xFF}]
			},
			{
				 "label":"DECISIONS"
				,"percent":-0.1
				,"color":[{"r":0,"g":255,"b":255, "a":0xFF}]
			}
		]
		,"textStartPosition": {"x":getScreenWidth()*0.8,"y":getScreenHeight()*0.7}
		//,"color":[{"g":0,"b":0}]
	});

	this.loader.addAnimation([
	{
		 "start": start, "duration": duration
		,"layer": layer
		,"fbo":{"name":"barChartFbo","action":"unbind"}
	}]);
}

Demo.prototype.preInitPowerPoint = function(start, duration) {
	var layer = 500;
	var loadingTime = 2;

	//PPT loader
	this.loader.addAnimation([
	{
		 "start":start, "duration": loadingTime
		,"layer": layer
		,"image": "data/ppt_empty.png"
		,"color": [{"a":255}]
		
	}]);
	var pptLoadingDuration = 1.5;
	this.loader.addAnimation([
	{
		 "start":start, "duration": loadingTime
		,"layer": layer
		,"image": "data/ppt_office.png"
		,"position": [{"x":405,"y":483},{"duration":pptLoadingDuration,"x":425}]
		,"color": [{"a":0},{"duration":pptLoadingDuration,"a":255}]
	}]);

	this.loader.addAnimation([
	{
		 "start":start, "duration": loadingTime
		,"layer": layer
		,"image": "data/ppt_powerpoint.png"
		,"position": [{"x":615,"y":370},{"duration":pptLoadingDuration,"x":635}]
		,"color": [{"a":0},{"duration":pptLoadingDuration,"a":255}]
		//,"color": [{"b":0,"r":0,"a":255}]		
	}]);

	start += loadingTime;
	duration -= loadingTime;

	var firstSlideDuration = 4.0;
	this.loader.addAnimation([
	{
		 "start":start, "duration": duration
		,"layer": layer
		,"image": "data/ppt_slide.png"
		,"color": [{"a":255}]
	}]);

	this.loader.addAnimation([
	{
		 "start":start, "duration": firstSlideDuration
		,"layer": layer, "text":{"name":fontName,"string":"Value proposition"}
		,"color": [
			   fontPrimaryColor
			  ,{"duration":firstSlideDuration-0.5}
			  ,{"duration":0.5,"a":0}
		]
		,"scale": [{"uniform2d":1.3}]
		,"position": [{"x":600,"y":340}]
	}]);

	this.loader.addAnimation([
	{
		 "start":start, "duration": firstSlideDuration
		,"layer": layer, "text":{"name":fontName,"string":"Jumalauta VC"}
		,"color": [
			   {"r":fontSecondaryColor.r,"g":fontSecondaryColor.g,"b":fontSecondaryColor.b}
			  ,{"duration":firstSlideDuration-0.5}
			  ,{"duration":0.5,"a":0}
		]
		,"scale": [{"uniform2d":0.8}]
		,"position": [{"x":445,"y":260}]
	}]);

	start += firstSlideDuration-0.25;
	var tocDuration = 6;

	this.loader.addAnimation([
	{
		 "start":start, "duration": tocDuration
		,"layer": layer, "text":{"name":fontName,"string":"Table of Contents"}
		,"color": [
			  {"r":fontPrimaryColor.r,"g":fontPrimaryColor.g,"b":fontPrimaryColor.b,"a":0}
			  ,{"duration":0.5,"a":255}
			  ,{"duration":tocDuration-0.75}
			  ,{"duration":0.25,"a":0}
		]
		,"scale": [{"uniform2d":1.1}]
		,"position": [{"x":350,"y":660}]
	}]);

	this.loader.addAnimation([
	{
		 "start":start, "duration": tocDuration
		,"layer": layer, "text":{"name":fontName,"string":"1. Slide 1"}
		,"color": [
			   {"r":fontSecondaryColor.r,"g":fontSecondaryColor.g,"b":fontSecondaryColor.b, "a":0}
			  ,{"duration":0.5,"a":255}
		]
		,"scale": [{"uniform2d":0.8}]
		,"position": [{"x":150,"y":500}]
	}]);

	start += tocDuration-0.25;

	var circleDiagramDuration = 11.25;
	this.preInitCircleDiagram(start, circleDiagramDuration);

	this.loader.addAnimation([
	{
		 "start":start, "duration": circleDiagramDuration
		,"layer": layer, "text":{"name":fontName,"string":"Rainbow challenge participants"}
		,"color": [
			  {"r":fontPrimaryColor.r,"g":fontPrimaryColor.g,"b":fontPrimaryColor.b,"a":0}
			  ,{"duration":0.5,"a":255}
			  ,{"duration":circleDiagramDuration-0.75}
			  ,{"duration":0.25,"a":0}
		]
		,"scale": [{"uniform2d":0.9}]
		,"position": [{"x":425,"y":660}]
	}]);

	this.loader.addAnimation([
	{
		 "start":start, "duration": circleDiagramDuration
		,"image": "circleDiagramFbo.color.fbo"
		,"scale": [{"uniform2d":0.8}]
		,"position": [{"x":500,"y":330}]
		,"color":[{"a":0},{"duration":0.25,"a":255}]
		,"layer": layer
	}]);

	start += circleDiagramDuration-0.25;
	var barChartDuration = 11.25;
	this.preInitBarChartDiagram(start, barChartDuration);

	this.loader.addAnimation([
	{
		 "start":start, "duration": barChartDuration
		,"layer": layer, "text":{"name":fontName,"string":"Return on investment"}
		,"color": [
			  {"r":fontPrimaryColor.r,"g":fontPrimaryColor.g,"b":fontPrimaryColor.b,"a":0}
			  ,{"duration":0.5,"a":255}
			  ,{"duration":barChartDuration-0.75}
			  ,{"duration":0.25,"a":0}
		]
		,"scale": [{"uniform2d":1.1}]
		,"position": [{"x":350,"y":660}]
	}]);

	this.loader.addAnimation([
	{
		 "start":start, "duration": barChartDuration
		,"image": "barChartFbo.color.fbo"
		,"scale": [{"uniform2d":0.8}]
		,"position": [{"x":500,"y":330}]
		,"color":[{"a":0},{"duration":0.25,"a":255}]
		,"layer": layer
	}]);

	start += barChartDuration-0.25;
	var magicQuadrantDuration = 11.50;
	this.preInitMagicQuadrant(start, magicQuadrantDuration);

	this.loader.addAnimation([
	{
		 "start":start, "duration": magicQuadrantDuration
		,"layer": layer, "text":{"name":fontName,"string":"JML's Magic Quadrant"}
		,"color": [
			  {"r":fontPrimaryColor.r,"g":fontPrimaryColor.g,"b":fontPrimaryColor.b,"a":0}
			  ,{"duration":0.5,"a":255}
		]
		,"scale": [{"uniform2d":1.1}]
		,"position": [{"x":350,"y":660}]
	}]);

	this.loader.addAnimation([
	{
		 "start":start, "duration": magicQuadrantDuration
		,"image": "magicQuadrantFbo.color.fbo"
		,"scale": [{"uniform2d":0.8}]
		,"position": [{"x":500,"y":330}]
		,"color":[{"a":0},{"duration":0.25,"a":255}]
		,"layer": layer
	}]);

}

Demo.prototype.init = function() {
	var layer = 1;
	demoPlayer = this.player;

	this.loader.addAnimation([
	{
		 "start":0, "duration": 300
		,"image": "data/vignette.png"
		,"layer": 400
		,"color": [{"a":200}]
		
	}]);

	this.loader.addAnimation([
	{
		 "start": 0, "duration": 300
		,"image": "data/blank.png"
		,"layer": 0
		,"shader":{"name":"data/shader/background.fs",
			"variable":[
			    {"name":"time","value":["{return getSceneTimeFromStart();}"]}
			]
		}
		,"color": [{"r":255,"a":255}]
	}]);

	this.preInitCarLights(0, 22);

	this.preInitSkyscraper(22, 43.5-22);

	var buzzWordBingo = [
		"MOTIVATION",
		"INNOVATION",
		"SYNERGY",
		"AWESOMENESS",
		"EQUALITY",
		"QUALITY",
		"SELF-DRIVEN"
	];

	var originalLength = buzzWordBingo.length;
	for (var wisdom_i = 0; wisdom_i < originalLength; wisdom_i++) {
		var wisdomDelay = wisdom_i * (6.50-0.5);
		this.loader.addAnimation([
		{
			 "start": wisdomDelay, "duration": 6.50
			,"layer": layer+1, "text":{"name":fontName,"string":randomPopAnswer(buzzWordBingo)}
			,"color":[
				 {"r":fontSecondaryColor.r,"g":fontSecondaryColor.g,"b":fontSecondaryColor.b,"a":0}
				,{"a":255,"duration":0.5}
				,{"duration":5.25}
				,{"a":0,"duration":0.50}
			]
			,"scale": [{"uniform2d":2.5}]
			//,"position": [{"x":280,"y":100}]
		}]);
	}


	this.preInitProductPlanning(43.5, 68-43.5);

	this.preInitPowerPoint(65.5, 110.5-65.5);

	this.preInitFinalProduct(110.5, 132.5-110.5);

	this.preInitEndAnimation(layer, 132.5, 149-132.5);
}

